/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.lukemurphey.nsia.web.forms.Field;
import net.lukemurphey.nsia.web.forms.FieldError;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.forms.FieldValidatorResponse;

public class Form {
    private HashMap<String, Field> fields = new HashMap();

    public void addField(Field field) {
        this.fields.put(field.getName().toLowerCase(), field);
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    private void addIfUnique(ArrayList<Field> fieldsUsed, Field field) {
        for (Field existingField : fieldsUsed) {
            if (existingField != field) continue;
            return;
        }
        fieldsUsed.add(field);
    }

    public FieldErrors validate(HttpServletRequest request) {
        FieldErrors errors = new FieldErrors();
        Map params = request.getParameterMap();
        Set paramNames = params.keySet();
        ArrayList<Field> fieldsUsed = new ArrayList<Field>();
        for (String fieldName : this.fields.keySet()) {
            Field field = this.fields.get(fieldName);
            block1: for (String paramName : paramNames) {
                String[] args;
                if (!field.getName().equalsIgnoreCase(paramName)) continue;
                String[] stringArray = args = request.getParameterValues(paramName);
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    FieldValidatorResponse response = field.validate(arg);
                    this.addIfUnique(fieldsUsed, field);
                    if (!response.isValid()) {
                        errors.put(new FieldError(field.getName(), arg, response.getMessage()));
                        continue block1;
                    }
                    ++n2;
                }
            }
        }
        Set<String> fieldKeys = this.fields.keySet();
        for (String fieldName : fieldKeys) {
            Field field = this.fields.get(fieldName);
            if (!field.isRequired()) continue;
            boolean found = false;
            for (Field usedField : fieldsUsed) {
                if (usedField != field) continue;
                found = true;
                break;
            }
            if (found) continue;
            errors.put(new FieldError(field.getName(), field.getName(), "This field is required"));
        }
        return errors;
    }
}

