/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.forms;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.web.forms.FieldValidator;
import net.lukemurphey.nsia.web.forms.FieldValidatorResponse;

public class PatternValidator
implements FieldValidator {
    private Pattern pattern = null;
    private String defaultMessage = null;

    public PatternValidator(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("The pattern cannot be null");
        }
        this.pattern = Pattern.compile(pattern);
    }

    public PatternValidator(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("The pattern cannot be null");
        }
        this.pattern = pattern;
    }

    public PatternValidator(String pattern, String message) {
        if (pattern == null) {
            throw new IllegalArgumentException("The pattern cannot be null");
        }
        this.pattern = Pattern.compile(pattern);
        this.defaultMessage = message;
    }

    public PatternValidator(Pattern pattern, String message) {
        if (pattern == null) {
            throw new IllegalArgumentException("The pattern cannot be null");
        }
        this.pattern = pattern;
        this.defaultMessage = message;
    }

    @Override
    public FieldValidatorResponse validate(String value) {
        Matcher matcher = this.pattern.matcher(value);
        if (!matcher.matches()) {
            return new FieldValidatorResponse(false, this.defaultMessage);
        }
        return new FieldValidatorResponse(true, this.defaultMessage);
    }
}

