/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.middleware;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.middleware.Middleware;
import net.lukemurphey.nsia.web.middleware.MiddlewareException;

public class SessionActivityMiddleware
extends Middleware {
    @Override
    public boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws MiddlewareException {
        SessionManagement.SessionInfo sessionInfo = context.getSessionInfo();
        if (sessionInfo != null && sessionInfo.getSessionStatus() == SessionStatus.SESSION_ACTIVE) {
            if (request.getParameter("refreshRate") != null || request.getParameter("isajax") != null) {
                return false;
            }
            SessionManagement sessionManagement = new SessionManagement(Application.getApplication());
            try {
                sessionManagement.resetSessionActivity(context.getSessionInfo().getSessionIdentifier());
            }
            catch (InputValidationException e) {
                throw new MiddlewareException("Exception thrown when reset session activity", e);
            }
            catch (NoDatabaseConnectionException e) {
                throw new MiddlewareException("Exception thrown when reset session activity", e);
            }
            catch (SQLException e) {
                throw new MiddlewareException("Exception thrown when reset session activity", e);
            }
        }
        return false;
    }
}

