/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.templates;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;

public class DurationTemplateDirective
implements TemplateDirectiveModel {
    private static final String PARAM_TIME_SECS = "seconds";

    public void execute(Environment env, Map params, TemplateModel[] model, TemplateDirectiveBody body) throws TemplateException, IOException {
        Iterator paramIter = params.entrySet().iterator();
        int time_secs = 0;
        boolean time_provided = false;
        while (paramIter.hasNext()) {
            Map.Entry ent = paramIter.next();
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (!paramName.equals(PARAM_TIME_SECS) || paramValue instanceof TemplateNumberModel) continue;
            time_secs = ((TemplateNumberModel)paramValue).getAsNumber().intValue();
            time_provided = true;
        }
        if (!time_provided) {
            throw new TemplateModelException("Duration was not provided");
        }
        Writer out = env.getOut();
        if (body != null) {
            out.write(DurationTemplateDirective.getTimeDescription(time_secs));
        }
    }

    private static String getTimeDescription(long secs) {
        double doubleSecs = secs;
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        if (secs < 60L) {
            return String.valueOf(secs) + " sec";
        }
        if (secs < 3600L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 60.0)) + " min";
        }
        if (secs < 86400L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 3600.0)) + " hours";
        }
        return String.valueOf(twoPlaces.format(doubleSecs / 86400.0)) + " days";
    }
}

