/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.templates;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.templates.DialogTemplateDirective;
import net.lukemurphey.nsia.web.templates.TruncateCharsDirective;
import net.lukemurphey.nsia.web.templates.URLTemplateDirective;

public class TemplateLoader {
    private static Configuration config = null;

    public static synchronized Configuration getConfig() {
        if (config == null) {
            config = new Configuration();
            config.setSharedVariable("url", (TemplateModel)new URLTemplateDirective());
            config.setSharedVariable("truncate_chars", (TemplateModel)new TruncateCharsDirective());
            config.setSharedVariable("dialog", (TemplateModel)new DialogTemplateDirective());
            config.setClassForTemplateLoading(TemplateLoader.class, "");
        }
        return config;
    }

    public static String renderToString(String templateName, Map<String, Object> data) throws ViewFailedException {
        Template template = TemplateLoader.getTemplate(templateName);
        StringWriter writer = new StringWriter();
        try {
            template.process(data, (Writer)writer);
        }
        catch (IOException e) {
            throw new ViewFailedException("Exception thrown while rendering template", e);
        }
        catch (TemplateException e) {
            throw new ViewFailedException("Exception thrown while rendering template", e);
        }
        writer.flush();
        return writer.getBuffer().toString();
    }

    public static void renderToResponse(String templateName, Map<String, Object> data, HttpServletResponse response) throws ViewFailedException {
        TemplateLoader.renderToResponse(templateName, data, response, null);
    }

    public static void renderToResponse(String templateName, Map<String, Object> data, HttpServletResponse response, String content_type) throws ViewFailedException {
        PrintWriter writer;
        Template template = TemplateLoader.getTemplate(templateName);
        try {
            if (content_type != null && !response.isCommitted()) {
                response.setContentType(content_type);
            } else if (content_type == null && response.getContentType() == null && !response.isCommitted()) {
                response.setContentType("text/html");
            }
            writer = response.getWriter();
            template.process(data, (Writer)writer);
        }
        catch (IOException e) {
            throw new ViewFailedException("Exception thrown while rendering template", e);
        }
        catch (TemplateException e) {
            throw new ViewFailedException("Exception thrown while rendering template", e);
        }
        writer.flush();
    }

    public static Template getTemplate(String name) throws ViewFailedException {
        try {
            return TemplateLoader.getConfig().getTemplate(name);
        }
        catch (IOException e) {
            throw new ViewFailedException("Template named \"" + name + "\" could not be found", e);
        }
    }
}

