/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.templates;

import freemarker.core.Environment;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.ViewNotFoundException;

public class URLTemplateDirective
implements TemplateDirectiveModel {
    public static final String PARAM_VIEW_NAME = "name";
    public static final String PARAM_ARGS = "args";

    public void execute(Environment env, Map params, TemplateModel[] model, TemplateDirectiveBody body) throws TemplateException, IOException {
        String url;
        Iterator paramIter = params.entrySet().iterator();
        String view_name = null;
        Vector<String> view_args = new Vector<String>();
        while (paramIter.hasNext()) {
            Object i;
            Object collection;
            Map.Entry ent = paramIter.next();
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (paramName.equals(PARAM_VIEW_NAME)) {
                view_name = paramValue.toString();
                continue;
            }
            if (!paramName.equals(PARAM_ARGS)) continue;
            if (paramValue instanceof TemplateCollectionModel) {
                collection = (TemplateCollectionModel)paramValue;
                i = collection.iterator();
                while (i.hasNext()) {
                    view_args.add(i.next().toString());
                }
                continue;
            }
            if (paramValue instanceof SimpleSequence) {
                collection = ((SimpleSequence)paramValue).toList();
                i = collection.iterator();
                while (i.hasNext()) {
                    view_args.add(i.next().toString());
                }
                continue;
            }
            throw new TemplateModelException("The \"args\" parameter must be a collection or a simple sequence.");
        }
        if (view_name == null) {
            throw new TemplateModelException("View name was not provided");
        }
        Object[] args_array = new String[view_args.size()];
        view_args.toArray(args_array);
        try {
            url = StandardViewList.getURL(view_name, args_array);
        }
        catch (URLInvalidException e) {
            throw new TemplateModelException("The URL constructed for view \"" + view_name + "\" is invalid.");
        }
        catch (ViewNotFoundException e) {
            throw new TemplateModelException("View \"" + view_name + "\" was not found.");
        }
        Writer out = env.getOut();
        out.write(url);
    }
}

