/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.AccessControlView;
import net.lukemurphey.nsia.web.views.Dialog;

public class AccessControlDeleteView
extends View {
    public static final String VIEW_NAME = "access_control_delete";

    public AccessControlDeleteView() {
        super("AccessControl/Delete", VIEW_NAME, Pattern.compile("[0-9]+"), Pattern.compile("(User|Group)?", 2), Pattern.compile("[0-9]*"));
    }

    public static String getURL(int ruleID, GroupManagement.GroupDescriptor group) throws URLInvalidException {
        AccessControlDeleteView view = new AccessControlDeleteView();
        return view.createURL(ruleID, "Group", group.getGroupId());
    }

    public static String getURL(int ruleID, UserManagement.UserDescriptor user) throws URLInvalidException {
        AccessControlDeleteView view = new AccessControlDeleteView();
        return view.createURL(ruleID, "User", user.getUserID());
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        AccessControl accessControl;
        long subjectID;
        long objectId;
        block14: {
            block13: {
                block12: {
                    objectId = -1L;
                    subjectID = -1L;
                    if (args.length <= 0) break block12;
                    try {
                        objectId = Long.parseLong(args[0]);
                    }
                    catch (NumberFormatException e) {
                        Dialog.getDialog(response, context, data, "The ACL identifier provided is not valid", "ACL Identifier Not Valid", Dialog.DialogType.WARNING);
                        return true;
                    }
                    try {
                        subjectID = Long.parseLong(args[2]);
                    }
                    catch (NumberFormatException e) {
                        Dialog.getDialog(response, context, data, "The subject identifier provided is not valid", "Subject Identifier Not Valid", Dialog.DialogType.WARNING);
                        return true;
                    }
                }
                if (Shortcuts.canControl(context.getSessionInfo(), objectId, "Remove permissions for object ID " + objectId)) break block13;
                data.put("title", "Access Control Entry Delete");
                data.put("permission_denied_message", "You do not have permission to edit the access control list");
                TemplateLoader.renderToResponse("AccessControl.ftl", data, response);
                return true;
            }
            accessControl = new AccessControl(Application.getApplication());
            if (!"User".equalsIgnoreCase(args[1])) break block14;
            accessControl.deleteUserPermissions(subjectID, objectId);
            Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, subjectID));
            context.addMessage("ACL successfully deleted", SessionMessages.MessageSeverity.SUCCESS);
            response.sendRedirect(AccessControlView.getURL(objectId));
            return true;
        }
        try {
            accessControl.deleteGroupPermissions(subjectID, objectId);
            Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.GROUP_ID, subjectID));
            context.addMessage("ACL successfully deleted", SessionMessages.MessageSeverity.SUCCESS);
            response.sendRedirect(AccessControlView.getURL(objectId));
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
    }
}

