/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.eventlog.SiteGroupStatusEventLogHook;
import net.lukemurphey.nsia.extension.ArgumentFieldsInvalidException;
import net.lukemurphey.nsia.extension.Extension;
import net.lukemurphey.nsia.extension.ExtensionManager;
import net.lukemurphey.nsia.extension.ExtensionType;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.forms.FieldError;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.ActionsListView;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.MainDashboardView;
import net.lukemurphey.nsia.web.views.SiteGroupView;

public class ActionEditView
extends View {
    public static final String VIEW_NAME = "sitegroup_action_editor";

    public ActionEditView() {
        super("Actions/SiteGroup", VIEW_NAME, Pattern.compile("(Edit)|(New)", 2), Pattern.compile("[0-9]*"));
    }

    public static String getURL(int siteGroupID) throws URLInvalidException {
        ActionEditView view = new ActionEditView();
        return view.createURL("Edit", siteGroupID);
    }

    public static String getURL() throws URLInvalidException {
        ActionEditView view = new ActionEditView();
        return view.createURL("New");
    }

    private Hashtable<String, String> getArguments(HttpServletRequest request) {
        Hashtable<String, String> modulesArguments = new Hashtable<String, String>();
        Enumeration argsNames = request.getParameterNames();
        while (argsNames.hasMoreElements()) {
            String name = (String)argsNames.nextElement();
            if (!name.startsWith("_")) continue;
            modulesArguments.put(name.substring(1), request.getParameter(name));
        }
        return modulesArguments;
    }

    private Extension getExtension(String name) {
        ExtensionManager extensionManager = ExtensionManager.getExtensionManager();
        return extensionManager.getExtension(ExtensionType.INCIDENT_RESPONSE_MODULE, name);
    }

    private boolean processUpdateToHook(HttpServletRequest request, HttpServletResponse response, RequestContext context, Map<String, Object> data, SiteGroupManagement.SiteGroupDescriptor siteGroup, ScanRule rule, EventLogHook hook) throws IOException, URLInvalidException, ViewFailedException {
        Hashtable<String, String> modulesArguments = this.getArguments(request);
        try {
            Action action = hook.getAction();
            action.configure(modulesArguments);
            hook.saveToDatabase();
            response.sendRedirect(ActionsListView.getURL(siteGroup.getGroupId()));
            context.addMessage("Action successfully updated", SessionMessages.MessageSeverity.SUCCESS);
            Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, hook.getEventLogHookID()), new EventLogField(EventLogField.FieldName.GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.GROUP_NAME, siteGroup.getGroupName())));
            return true;
        }
        catch (ArgumentFieldsInvalidException e) {
            FieldErrors errors = new FieldErrors();
            errors.put(new FieldError(e.getInvalidField().getName(), "", e.getMessage()));
            data.put("form_errors", errors);
            return false;
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
    }

    private boolean processNewHook(HttpServletRequest request, HttpServletResponse response, RequestContext context, Map<String, Object> data, SiteGroupManagement.SiteGroupDescriptor siteGroup, ScanRule rule, String selectedActionType) throws IOException, URLInvalidException, ViewFailedException {
        Hashtable<String, String> modulesArguments = this.getArguments(request);
        Extension extension = this.getExtension(selectedActionType);
        try {
            Action action = (Action)extension.createInstance(modulesArguments);
            action.save();
            SiteGroupStatusEventLogHook hook = new SiteGroupStatusEventLogHook(action, siteGroup.getGroupId(), EventLogSeverity.WARNING);
            hook.saveToDatabase();
            Application.getApplication().getEventLog().addHook(hook);
            response.sendRedirect(ActionsListView.getURL(siteGroup.getGroupId()));
            context.addMessage("Action successfully created", SessionMessages.MessageSeverity.SUCCESS);
            Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_ADDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, hook.getEventLogHookID()), new EventLogField(EventLogField.FieldName.GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.GROUP_NAME, siteGroup.getGroupName())));
            return true;
        }
        catch (ArgumentFieldsInvalidException e) {
            FieldErrors errors = new FieldErrors();
            errors.put(new FieldError(e.getInvalidField().getName(), "", e.getMessage()));
            data.put("form_errors", errors);
            return false;
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            EventLogHook hook = null;
            if ("Edit".equalsIgnoreCase(args[0]) && args.length >= 2) {
                int hookID = Integer.valueOf(args[1]);
                hook = Application.getApplication().getEventLog().getHook(hookID);
                if (hook != null) {
                    data.put("action", hook.getAction());
                }
            }
            data.put("hook", hook);
            SiteGroupManagement.SiteGroupDescriptor siteGroup = null;
            SiteGroupStatusEventLogHook siteGroupHook = null;
            if (hook != null && hook instanceof SiteGroupStatusEventLogHook) {
                siteGroupHook = (SiteGroupStatusEventLogHook)hook;
                try {
                    SiteGroupManagement siteGroupMgmt = new SiteGroupManagement(Application.getApplication());
                    siteGroup = siteGroupMgmt.getGroupDescriptor(siteGroupHook.getSiteGroupID());
                }
                catch (NotFoundException e) {
                    Dialog.getDialog(response, context, data, "The site-group associated with the given action could not be found", "Site-group Not Found", Dialog.DialogType.INFORMATION);
                    return true;
                }
                data.put("siteGroup", siteGroup);
            } else if (hook == null && request.getParameter("SiteGroupID") != null) {
                try {
                    int siteGroupID = Integer.valueOf(request.getParameter("SiteGroupID"));
                    SiteGroupManagement siteGroupMgmt = new SiteGroupManagement(Application.getApplication());
                    siteGroup = siteGroupMgmt.getGroupDescriptor(siteGroupID);
                }
                catch (NotFoundException e) {
                    Dialog.getDialog(response, context, data, "The site-group to create the rule for was not specified", "Site-group Not Specified", Dialog.DialogType.INFORMATION);
                    return true;
                }
                data.put("siteGroup", siteGroup);
            } else {
                Dialog.getDialog(response, context, data, "The site-group to create the rule for was not specified", "Site-group Not Specified", Dialog.DialogType.INFORMATION);
                return true;
            }
            if (request.getParameter("Cancel") != null) {
                response.sendRedirect(ActionsListView.getURL(siteGroup));
                return true;
            }
            data.put("menu", Menu.getSiteGroupMenu(context, siteGroup));
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", MainDashboardView.getURL()));
            breadcrumbs.add(new Link("Site-group: " + siteGroup.getGroupName(), SiteGroupView.getURL(siteGroup.getGroupId())));
            breadcrumbs.add(new Link("Actions", ActionsListView.getURL(siteGroup.getGroupId())));
            if ("Edit".equalsIgnoreCase(args[0])) {
                breadcrumbs.add(new Link("Edit Action: " + hook.getAction().getDescription(), this.createURL("Edit", hook.getEventLogHookID())));
                data.put("title", "Edit Incident Response Action");
            } else {
                breadcrumbs.add(new Link("New Action", String.valueOf(this.createURL("New")) + "?SiteGroupID=" + siteGroup.getGroupId()));
                data.put("title", "New Incident Response Action");
            }
            data.put("breadcrumbs", breadcrumbs);
            Shortcuts.addDashboardHeaders(request, response, data);
            try {
                if (!Shortcuts.canModify(context.getSessionInfo(), siteGroup.getObjectId(), "Edit incident response action for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                    data.put("permission_denied_message", "You do not permission to edit this site-group.");
                    data.put("permission_denied_link", new Link("View Site Group", SiteGroupView.getURL(siteGroup)));
                    TemplateLoader.renderToResponse("PermissionDenied.ftl", data, response);
                    return true;
                }
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
            String actionType = request.getParameter("Extension");
            ExtensionManager extensionManager = ExtensionManager.getExtensionManager();
            data.put("extension", extensionManager.getExtension(ExtensionType.INCIDENT_RESPONSE_MODULE, actionType));
            if (hook == null && actionType == null) {
                data.put("extensions", ExtensionManager.getExtensionManager().getExtensions(ExtensionType.INCIDENT_RESPONSE_MODULE));
                TemplateLoader.renderToResponse("ResponseActionSelectType.ftl", data, response);
                return true;
            }
            if ("New".equalsIgnoreCase(args[0]) && request.getMethod().equalsIgnoreCase("GET")) {
                TemplateLoader.renderToResponse("ResponseActionEdit.ftl", data, response);
                return true;
            }
            if ("New".equalsIgnoreCase(args[0]) && request.getMethod().equalsIgnoreCase("POST")) {
                if (this.processNewHook(request, response, context, data, siteGroup, null, actionType)) {
                    return true;
                }
                TemplateLoader.renderToResponse("ResponseActionEdit.ftl", data, response);
                return true;
            }
            if ("Edit".equalsIgnoreCase(args[0]) && request.getMethod().equalsIgnoreCase("POST")) {
                if (this.processUpdateToHook(request, response, context, data, siteGroup, null, hook)) {
                    return true;
                }
                TemplateLoader.renderToResponse("ResponseActionEdit.ftl", data, response);
                return true;
            }
            if ("Edit".equalsIgnoreCase(args[0])) {
                TemplateLoader.renderToResponse("ResponseActionEdit.ftl", data, response);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
    }

    public static enum Scope {
        SITE_GROUP,
        RULE,
        GLOBAL;

    }
}

