/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DatabaseBackup;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.SystemStatusView;

public class BackupView
extends View {
    public BackupView() {
        super("System/Backup", "system_backup", new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        BackupView view = new BackupView();
        return view.createURL(new Object[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        boolean isAjax;
        if ("Cancel".equalsIgnoreCase(request.getParameter("Selected"))) {
            response.sendRedirect(StandardViewList.getURL("main_dashboard", new Object[0]));
            return true;
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Perform system backup")) {
                context.addMessage("You do not have permission to perform database backups", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(SystemStatusView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        Application.WorkerThreadDescriptor backupWorker = this.getWorkerThread(false);
        boolean startedNow = false;
        if ("Backup".equalsIgnoreCase(request.getParameter("Selected"))) {
            startedNow = true;
            backupWorker = this.startBackup();
            Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.DATABASE_BACKUP_STARTED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID())));
        }
        boolean bl = isAjax = request.getParameter("AJAX") != null;
        if (isAjax && backupWorker == null) {
            response.getWriter().print(Dialog.getProgressDialog("Backup complete", "Database Backup", 100, new Link("OK", this.createURL(new Object[0]))));
            return true;
        }
        if (isAjax && backupWorker != null && backupWorker.getWorkerThread().getStatus() == WorkerThread.State.STOPPED) {
            response.getWriter().print(Dialog.getProgressDialog(backupWorker.getWorkerThread().getStatusDescription(), backupWorker.getWorkerThread().getTaskDescription(), 100, new Link("OK", this.createURL(new Object[0]))));
            return true;
        }
        if (isAjax) {
            response.getWriter().print(Dialog.getProgressDialog(backupWorker.getWorkerThread().getStatusDescription(), backupWorker.getWorkerThread().getTaskDescription(), backupWorker.getWorkerThread().getProgress(), new Link[0]));
            return true;
        }
        Shortcuts.addDashboardHeaders(request, response, data);
        if (backupWorker != null && (startedNow || backupWorker.getWorkerThread().getStatus() == WorkerThread.State.STARTING || backupWorker.getWorkerThread().getStatus() == WorkerThread.State.STARTED)) {
            data.put("ajaxurl", String.valueOf(this.createURL(new Object[0])) + "?AJAX=True");
            data.put("title", "Database Backup");
            data.put("noajaxurl", this.createURL(new Object[0]));
            data.put("content", Dialog.getProgressDialog(backupWorker.getWorkerThread().getStatusDescription(), backupWorker.getWorkerThread().getTaskDescription(), backupWorker.getWorkerThread().getProgress(), new Link[0]));
            response.getWriter().println(TemplateLoader.renderToString("AJAXProgressDialog.ftl", data));
            return true;
        }
        Dialog.getOptionDialog(response, context, data, "Are you sure you want to create a backup of the database?", "Backup System", Dialog.DialogType.INFORMATION, new Link("Backup", this.createURL(new Object[0])), new Link("Cancel", this.createURL(new Object[0])));
        return true;
    }

    private Application.WorkerThreadDescriptor getWorkerThread(boolean aliveThreadsOnly) {
        Application.WorkerThreadDescriptor[] workerThreads = Application.getApplication().getWorkerThreadQueue(aliveThreadsOnly);
        Application.WorkerThreadDescriptor backupWorker = null;
        int c = 0;
        while (c < workerThreads.length) {
            if (workerThreads[c].getWorkerThread().getTaskDescription().equalsIgnoreCase("Database Backup") && (workerThreads[c].getWorkerThread().getStatus() == WorkerThread.State.STARTED || workerThreads[c].getWorkerThread().getStatus() == WorkerThread.State.INITIALIZED)) {
                backupWorker = workerThreads[c];
            }
            ++c;
        }
        return backupWorker;
    }

    private Application.WorkerThreadDescriptor startBackup() {
        DatabaseBackup databaseBackup = new DatabaseBackup();
        Application.WorkerThreadDescriptor desc = null;
        try {
            desc = Application.getApplication().addWorkerToQueue(databaseBackup, "Database Backup");
            Thread thread = new Thread(databaseBackup);
            thread.start();
        }
        catch (DuplicateEntryException duplicateEntryException) {
            // empty catch block
        }
        return desc;
    }
}

