/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class DashboardDefinitionsUpdate
extends View {
    private static long lastChecked = 0L;
    private static boolean newerAvailable = false;
    private static Thread checkerThread;
    private static boolean checkingVersion;
    private static Date currentDefinitionsDate;
    private static DefinitionSet.DefinitionVersionID currentDefinitionsID;
    private static DefinitionSet.DefinitionVersionID loadedVersionID;
    public static final int CHECK_FREQUENCY_SECS = 1800;

    static {
        checkingVersion = false;
        currentDefinitionsDate = null;
        currentDefinitionsID = null;
        loadedVersionID = null;
    }

    public DashboardDefinitionsUpdate() {
        super("DashboardPanel/UpdatedDefinitions", "dashboard_panel_definition_updates", new Pattern[0]);
        this.isNewerVersionAvailable();
    }

    private boolean hasOfficialDefinitions() {
        Application application = Application.getApplication();
        try {
            if (!application.getApplicationParameters().doesParameterExist("_DefinitionDate") || !application.getApplicationParameters().doesParameterExist("_DefinitionVersion")) {
                return false;
            }
        }
        catch (InputValidationException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        catch (NoDatabaseConnectionException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        catch (SQLException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        return true;
    }

    protected boolean definitionsChanged() {
        if (!this.hasOfficialDefinitions()) {
            return false;
        }
        if (loadedVersionID == null) {
            return true;
        }
        try {
            DefinitionArchive archive = DefinitionArchive.getArchive();
            return !loadedVersionID.equals(archive.getVersionID());
        }
        catch (DefinitionSetLoadException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        catch (SQLException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        catch (NoDatabaseConnectionException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        catch (InputValidationException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
        }
        return false;
    }

    private boolean needsUpdateCheck() {
        return lastChecked < System.currentTimeMillis() - 1800000L;
    }

    protected synchronized boolean isNewerVersionAvailable() {
        if (this.definitionsChanged() || !checkingVersion && this.needsUpdateCheck()) {
            checkerThread = new VersionChecker();
            checkerThread.setName("Definitions Update Version Checker");
            checkerThread.start();
            return false;
        }
        return newerAvailable;
    }

    public String getPanel(HttpServletRequest request, Map<String, Object> data, Application app) throws ViewFailedException {
        try {
            if (Application.getApplication().getApplicationConfiguration().getAutoDefinitionUpdating()) {
                return null;
            }
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        if (this.isNewerVersionAvailable() && currentDefinitionsID != null) {
            data.put("new_version", String.valueOf(currentDefinitionsID.formatID()) + "." + currentDefinitionsID.revisionID());
            data.put("new_version_date", currentDefinitionsDate);
            return TemplateLoader.renderToString("DashboardDefinitionUpdate.ftl", data);
        }
        return null;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        String panel = this.getPanel(request, data, Application.getApplication());
        if (panel != null) {
            response.getOutputStream().print(panel);
        }
        return true;
    }

    static /* synthetic */ void access$0(boolean bl) {
        checkingVersion = bl;
    }

    static /* synthetic */ void access$1(long l) {
        lastChecked = l;
    }

    static /* synthetic */ void access$2(DefinitionSet.DefinitionVersionID definitionVersionID) {
        loadedVersionID = definitionVersionID;
    }

    static /* synthetic */ void access$3(boolean bl) {
        newerAvailable = bl;
    }

    static /* synthetic */ void access$4(Date date) {
        currentDefinitionsDate = date;
    }

    static /* synthetic */ void access$5(DefinitionSet.DefinitionVersionID definitionVersionID) {
        currentDefinitionsID = definitionVersionID;
    }

    private static class VersionChecker
    extends Thread {
        private VersionChecker() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

