/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class DashboardLicensePanel
extends View {
    public static final boolean IGNORE_NO_LICENSE = true;

    public DashboardLicensePanel() {
        super("DashboardPanel/License", "dashboard_panel_license", new Pattern[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        String panel = this.getPanel(request, data, Application.getApplication());
        if (panel != null) {
            response.getOutputStream().print(panel);
        }
        return true;
    }

    public String getPanel(HttpServletRequest request, Map<String, Object> data, Application app) throws ViewFailedException {
        boolean license_unvalidated;
        LicenseDescriptor license;
        try {
            license = app.getApplicationConfiguration().getLicense(true);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        data.put("ACTIVE", (Object)LicenseDescriptor.LicenseStatus.ACTIVE);
        data.put("DEMO", (Object)LicenseDescriptor.LicenseStatus.DEMO);
        data.put("DISABLED", (Object)LicenseDescriptor.LicenseStatus.DISABLED);
        data.put("EXPIRED", (Object)LicenseDescriptor.LicenseStatus.EXPIRED);
        data.put("ILLEGAL", (Object)LicenseDescriptor.LicenseStatus.ILLEGAL);
        data.put("UNLICENSED", (Object)LicenseDescriptor.LicenseStatus.UNLICENSED);
        data.put("UNVALIDATED", (Object)LicenseDescriptor.LicenseStatus.UNVALIDATED);
        boolean bl = license_unvalidated = license == null || license.getStatus() == null || license.getStatus() == LicenseDescriptor.LicenseStatus.UNVALIDATED;
        if (license != null && license.getStatus() == LicenseDescriptor.LicenseStatus.UNLICENSED) {
            return null;
        }
        if (app.getApplicationConfiguration().licenseKeyCheckCompleted() && (license == null || !license.isValid())) {
            data.put("license_check_completed", !license_unvalidated);
            data.put("license", license);
            return TemplateLoader.renderToString("DashboardLicenseWarning.ftl", data);
        }
        return null;
    }
}

