/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SiteGroupScanResult;
import net.lukemurphey.nsia.scan.ScanData;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class DashboardStatusPanel
extends View {
    public DashboardStatusPanel() {
        super("DashboardPanel/Status", "dashboard_panel_status", new Pattern[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        this.populateData(data, Application.getApplication());
        TemplateLoader.renderToResponse("DashboardStatusHeader.ftl", data, response);
        return true;
    }

    private void populateData(Map<String, Object> data, Application app) throws ViewFailedException {
        SiteGroupScanResult[] siteGroupScanResults;
        Application.ApplicationStatusDescriptor status_desc = app.getManagerStatus();
        if (status_desc.getOverallStatus() == 0) {
            data.put("manager", new StatusDescriptor(StatusIndicator.GREEN, "System Status: " + status_desc.getShortDescription()));
        } else if (status_desc.getOverallStatus() == 2) {
            data.put("manager", new StatusDescriptor(StatusIndicator.RED, "System Status: " + status_desc.getShortDescription()));
        } else {
            data.put("manager", new StatusDescriptor(StatusIndicator.YELLOW, "System Status: " + status_desc.getShortDescription()));
        }
        int rejected = 0;
        int incomplete = 0;
        ScanData scanData = new ScanData(app);
        try {
            siteGroupScanResults = scanData.getSiteGroupStatus();
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            throw new ViewFailedException(e);
        }
        SiteGroupScanResult[] siteGroupScanResultArray = siteGroupScanResults;
        int n = siteGroupScanResults.length;
        int n2 = 0;
        while (n2 < n) {
            SiteGroupScanResult siteGroupScanResult = siteGroupScanResultArray[n2];
            if (siteGroupScanResult.getSiteGroupDescriptor().isEnabled()) {
                if (siteGroupScanResult.getDeviatingRules() > 0) {
                    ++rejected;
                } else if (siteGroupScanResult.getIncompleteRules() > 0) {
                    ++incomplete;
                }
            }
            ++n2;
        }
        if (rejected > 0) {
            data.put("scanner", new StatusDescriptor(StatusIndicator.RED, "Current Status: " + rejected + " Non-Compliant Sites"));
        } else if (incomplete > 0) {
            data.put("scanner", new StatusDescriptor(StatusIndicator.YELLOW, "Current Status: " + incomplete + " Sites Incompletely Evaluated"));
        } else {
            data.put("scanner", new StatusDescriptor(StatusIndicator.GREEN, "Current Status: No Deviations Noted"));
        }
    }

    public String getPanel(HttpServletRequest request, Map<String, Object> data, Application app) throws ViewFailedException {
        this.populateData(data, app);
        return TemplateLoader.renderToString("DashboardStatusHeader.ftl", data);
    }

    public static class StatusDescriptor {
        private StatusIndicator status;
        private String status_desc;

        public StatusDescriptor(StatusIndicator status, String description) {
            this.status = status;
            this.status_desc = description;
        }

        public boolean getStatusGreen() {
            return this.status == StatusIndicator.GREEN;
        }

        public boolean getStatusRed() {
            return this.status == StatusIndicator.RED;
        }

        public boolean getStatusYellow() {
            return this.status == StatusIndicator.YELLOW;
        }

        public String getStatusDescription() {
            return this.status_desc;
        }
    }

    public static enum StatusIndicator {
        GREEN,
        YELLOW,
        RED;

    }
}

