/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DisallowedOperationException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.DefinitionsView;
import net.lukemurphey.nsia.web.views.Dialog;

public class DefinitionDeleteView
extends View {
    public static final String VIEW_NAME = "definition_delete";

    public DefinitionDeleteView() {
        super("Definition/Delete", VIEW_NAME, Pattern.compile("[0-9]+", 2));
    }

    public static String getURL(int definitionID) throws URLInvalidException {
        DefinitionDeleteView view = new DefinitionDeleteView();
        return view.createURL(definitionID);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        int definitionID = -1;
        if (args.length >= 1) {
            try {
                definitionID = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                Dialog.getDialog(response, context, data, "The definition ID provided is invalid.", "Definition ID Invalid", Dialog.DialogType.WARNING);
                return true;
            }
        }
        if ("Cancel".equalsIgnoreCase(request.getParameter("Selected"))) {
            response.sendRedirect(StandardViewList.getURL("definition", definitionID));
            return true;
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Delete definition")) {
                context.addMessage("You do not have permission to delete definitions", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(DefinitionsView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        try {
            DefinitionArchive archive = DefinitionArchive.getArchive();
            archive.removeByID(definitionID);
            Application.getApplication().logEvent(EventLogMessage.EventType.DEFINITION_DELETED, new EventLogField(EventLogField.FieldName.DEFINITION_ID, definitionID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
            context.addMessage("Definition successfully deleted", SessionMessages.MessageSeverity.INFORMATION);
            response.sendRedirect(StandardViewList.getURL("definitions_list", new Object[0]));
            return true;
        }
        catch (DisallowedOperationException e) {
            Dialog.getDialog(response, context, data, e.getMessage(), "Delete Disallowed", Dialog.DialogType.WARNING);
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (DefinitionSetLoadException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
    }
}

