/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicyManagement;
import net.lukemurphey.nsia.scan.DefinitionPolicySet;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.SiteGroupView;
import org.apache.commons.lang.StringUtils;

public class DefinitionPolicyView
extends View {
    public static final String VIEW_NAME = "definitions_policy";

    public DefinitionPolicyView() {
        super("Definitions/Policy", VIEW_NAME, Pattern.compile("[0-9]*"));
    }

    public static String getURL() throws URLInvalidException {
        DefinitionPolicyView view = new DefinitionPolicyView();
        return view.createURL(new Object[0]);
    }

    public static String getURL(int siteGroupID) throws URLInvalidException {
        DefinitionPolicyView view = new DefinitionPolicyView();
        return view.createURL(siteGroupID);
    }

    public static String getURL(SiteGroupManagement.SiteGroupDescriptor siteGroup) throws URLInvalidException {
        DefinitionPolicyView view = new DefinitionPolicyView();
        return view.createURL(siteGroup.getGroupId());
    }

    private String getName(String name, String category, String subCategory) {
        String completeName = "";
        if (category != null) {
            completeName = String.valueOf(completeName) + category;
        }
        if (subCategory != null) {
            completeName = String.valueOf(completeName) + "." + subCategory;
        }
        if (name != null) {
            completeName = String.valueOf(completeName) + "." + name;
        }
        return completeName;
    }

    private CategoryDescriptor getDescriptor(DefinitionPolicySet policySet, int siteGroupID, DefinitionSet.DefinitionCategory definitionCategory) {
        DefinitionPolicyDescriptor descriptor = policySet.getMatchingPolicy(siteGroupID, -1L, null, definitionCategory.getCategory(), definitionCategory.getSubCategory(), null);
        return new CategoryDescriptor(this.getName(null, definitionCategory.getCategory(), definitionCategory.getSubCategory()), descriptor);
    }

    private String[] parseDefinition(String def) {
        return StringUtils.split((String)def, (String)".");
    }

    public void clearCategoryDescriptors(SessionManagement.SessionInfo session, String categoryName, String subCategoryName) throws GeneralizedException, NoSessionException, NotFoundException, InsufficientPermissionException, NoDatabaseConnectionException, SQLException {
        Shortcuts.checkRight(session, "System.Configuration.View", "Clear default policy for " + categoryName + "." + subCategoryName + ".*");
        DefinitionPolicyManagement defMgr = new DefinitionPolicyManagement(Application.getApplication());
        defMgr.clearSubCategoryDescriptors(categoryName, subCategoryName);
    }

    public void clearCategoryDescriptors(SessionManagement.SessionInfo session, String categoryName, String subCategoryName, SiteGroupManagement.SiteGroupDescriptor siteGroupDesc) throws GeneralizedException, NoSessionException, NotFoundException, InsufficientPermissionException, NoDatabaseConnectionException, SQLException {
        Shortcuts.checkModify(session, siteGroupDesc.getObjectId(), "Clear policies for " + categoryName + "." + subCategoryName + ".* for " + siteGroupDesc.getGroupName() + " (" + siteGroupDesc.getGroupId() + ")");
        DefinitionPolicyManagement defMgr = new DefinitionPolicyManagement(Application.getApplication());
        defMgr.clearSubCategoryDescriptors(siteGroupDesc, categoryName, subCategoryName);
    }

    public void addCategoryDescriptor(SessionManagement.SessionInfo session, String categoryName, String subCategoryName, DefinitionPolicyDescriptor.DefinitionPolicyAction action) throws GeneralizedException, NoSessionException, NotFoundException, InsufficientPermissionException {
        Connection connection = null;
        try {
            try {
                Shortcuts.checkRight(session, "System.Configuration.View", "Set " + action.name().toLowerCase() + " policy for " + categoryName + "." + subCategoryName + ".* at global level");
                DefinitionPolicyDescriptor filter = DefinitionPolicyDescriptor.createSubCategoryPolicy(categoryName, subCategoryName, action);
                connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                filter.saveToDatabase(connection);
            }
            catch (SQLException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                throw new GeneralizedException();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                }
            }
        }
    }

    private boolean addCategoryDescriptor(SessionManagement.SessionInfo session, String category, String subCategory, DefinitionPolicyDescriptor.DefinitionPolicyAction action, SiteGroupManagement.SiteGroupDescriptor siteGroupDesc) throws GeneralizedException, NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        try {
            if (Shortcuts.canModify(session, siteGroupDesc.getObjectId(), "Add " + action.name().toLowerCase() + " policy for " + category + "." + subCategory + ".* for " + siteGroupDesc.getGroupName() + " (" + siteGroupDesc.getGroupId() + ")")) {
                DefinitionPolicyDescriptor filter = DefinitionPolicyDescriptor.createSubCategoryPolicy(siteGroupDesc.getGroupId(), category, subCategory, action);
                connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                filter.saveToDatabase(connection);
                return true;
            }
            return false;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                }
            }
        }
    }

    private void processChanges(HttpServletRequest request, RequestContext context, SiteGroupManagement.SiteGroupDescriptor siteGroupDesc) throws GeneralizedException, NoDatabaseConnectionException, SQLException, ViewFailedException {
        block23: {
            String[] policies;
            String action;
            block24: {
                block22: {
                    action = request.getParameter("Action");
                    policies = request.getParameterValues("DefinitionPolicy");
                    if (!action.equalsIgnoreCase("Disable")) break block22;
                    if (policies == null || policies.length == 0) {
                        context.addMessage("Please select the definition categories to disable", SessionMessages.MessageSeverity.WARNING);
                        return;
                    }
                    String[] stringArray = policies;
                    int n = policies.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String policy = stringArray[n2];
                        String[] definition = this.parseDefinition(policy);
                        String category = definition[0];
                        String subCategory = definition[1];
                        try {
                            if (siteGroupDesc != null) {
                                this.addCategoryDescriptor(context.getSessionInfo(), category, subCategory, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE, siteGroupDesc);
                            } else {
                                this.addCategoryDescriptor(context.getSessionInfo(), category, subCategory, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
                            }
                        }
                        catch (InsufficientPermissionException e) {
                            context.addMessage("You don't have permissions to edit the scan policy", SessionMessages.MessageSeverity.WARNING);
                        }
                        catch (NotFoundException e) {
                            throw new ViewFailedException(e);
                        }
                        catch (NoSessionException e) {
                            throw new ViewFailedException(e);
                        }
                        ++n2;
                    }
                    break block23;
                }
                if (!action.equalsIgnoreCase("Enable")) break block24;
                if (policies == null || policies.length == 0) {
                    context.addMessage("Please select the definition categories to enable", SessionMessages.MessageSeverity.WARNING);
                    return;
                }
                String[] stringArray = policies;
                int n = policies.length;
                int n3 = 0;
                while (n3 < n) {
                    String policy = stringArray[n3];
                    String[] definition = this.parseDefinition(policy);
                    String category = definition[0];
                    String subCategory = definition[1];
                    try {
                        if (siteGroupDesc != null) {
                            this.addCategoryDescriptor(context.getSessionInfo(), category, subCategory, DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE, siteGroupDesc);
                        } else {
                            this.addCategoryDescriptor(context.getSessionInfo(), category, subCategory, DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE);
                        }
                    }
                    catch (InsufficientPermissionException e) {
                        context.addMessage("You don't have permissions to edit the scan policy", SessionMessages.MessageSeverity.WARNING);
                    }
                    catch (NotFoundException e) {
                        throw new ViewFailedException(e);
                    }
                    catch (NoSessionException e) {
                        throw new ViewFailedException(e);
                    }
                    ++n3;
                }
                break block23;
            }
            if (!action.equalsIgnoreCase("Set Default") || siteGroupDesc == null) break block23;
            if (policies == null || policies.length == 0) {
                context.addMessage("Please select the definition categories to modify", SessionMessages.MessageSeverity.WARNING);
                return;
            }
            String[] stringArray = policies;
            int n = policies.length;
            int n4 = 0;
            while (n4 < n) {
                String policy = stringArray[n4];
                String[] definition = this.parseDefinition(policy);
                String category = definition[0];
                String subCategory = definition[1];
                try {
                    this.clearCategoryDescriptors(context.getSessionInfo(), category, subCategory, siteGroupDesc);
                }
                catch (InsufficientPermissionException e) {
                    context.addMessage("You don't have permissions to edit the scan policy", SessionMessages.MessageSeverity.WARNING);
                }
                catch (NotFoundException e) {
                    context.addMessage("You don't have permissions to edit the scan policy", SessionMessages.MessageSeverity.WARNING);
                }
                catch (NoSessionException e) {
                    throw new ViewFailedException(e);
                }
                ++n4;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            int siteGroupID = -1;
            SiteGroupManagement.SiteGroupDescriptor siteGroup = null;
            if (args.length > 0) {
                try {
                    siteGroupID = Integer.valueOf(args[0]);
                    SiteGroupManagement siteGroupManagement = new SiteGroupManagement(Application.getApplication());
                    siteGroup = siteGroupManagement.getGroupDescriptor(siteGroupID);
                }
                catch (NumberFormatException e) {
                    Dialog.getDialog(response, context, data, "The site-group ID provided is invalid", "Site-Group ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
                catch (NotFoundException e) {
                    Dialog.getDialog(response, context, data, "No site-group found with the given ID", "Site-Group ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
            }
            data.put("title", "Definition Policy");
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            if (siteGroupID > -1) {
                breadcrumbs.add(new Link("Site-group: " + siteGroup.getGroupName(), SiteGroupView.getURL(siteGroupID)));
                breadcrumbs.add(new Link("Definition Policy", this.createURL(siteGroupID)));
            } else {
                breadcrumbs.add(new Link("Definitions", StandardViewList.getURL("definitions_list", new Object[0])));
                breadcrumbs.add(new Link("Default Definition Policy", this.createURL(new Object[0])));
            }
            data.put("breadcrumbs", breadcrumbs);
            data.put("menu", Menu.getDefinitionMenu(context));
            Shortcuts.addDashboardHeaders(request, response, data);
            try {
                if (siteGroup != null) {
                    if (!Shortcuts.canRead(context.getSessionInfo(), siteGroup.getObjectId(), "Get scan policy for site-group ID " + siteGroup.getGroupId() + "(" + siteGroup.getGroupName() + ")")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the scan policy for this site-group");
                        return true;
                    }
                } else if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.View", "Get global scan policy")) {
                    Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the default scan policy");
                    return true;
                }
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                try {
                    if (siteGroup != null) {
                        if (!Shortcuts.canModify(context.getSessionInfo(), siteGroup.getObjectId(), "Update scan policy for site-group ID " + siteGroup.getGroupId() + "(" + siteGroup.getGroupName() + ")")) {
                            Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit the scan policy for this site-group");
                            return true;
                        }
                    } else if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Update global scan policy")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit the default scan policy");
                        return true;
                    }
                }
                catch (GeneralizedException e) {
                    throw new ViewFailedException(e);
                }
                try {
                    this.processChanges(request, context, siteGroup);
                    if (siteGroup == null) {
                        Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.DEFAULT_SCAN_POLICY_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID())));
                    } else {
                        Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.SCAN_POLICY_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, siteGroup.getGroupName()), new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, siteGroup.getGroupId())));
                    }
                }
                catch (GeneralizedException e) {
                    throw new ViewFailedException(e);
                }
            }
            DefinitionPolicyManagement policyManagement = new DefinitionPolicyManagement(Application.getApplication());
            DefinitionPolicySet policySet = siteGroupID > -1 ? policyManagement.getPolicySet(siteGroupID) : policyManagement.getPolicySet();
            DefinitionArchive archive = DefinitionArchive.getArchive();
            DefinitionSet definitionSet = archive.getDefinitionSet();
            DefinitionSet.DefinitionCategory[] categories = definitionSet.getListOfSubCategories();
            Vector<CategoryDescriptor> descriptors = new Vector<CategoryDescriptor>();
            DefinitionSet.DefinitionCategory[] definitionCategoryArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    data.put("categories", descriptors);
                    data.put("sitegroup", siteGroup);
                    TemplateLoader.renderToResponse("DefinitionPolicy.ftl", data, response);
                    return true;
                }
                DefinitionSet.DefinitionCategory category = definitionCategoryArray[n2];
                descriptors.add(this.getDescriptor(policySet, siteGroupID, category));
                ++n2;
            }
        }
        catch (DefinitionSetLoadException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
    }

    public static class CategoryDescriptor {
        private String name;
        private boolean isDefault;
        private boolean enabled;

        public CategoryDescriptor(String categoryName, DefinitionPolicyDescriptor descriptor) {
            if (descriptor == null) {
                this.isDefault = true;
                this.enabled = true;
            } else if (descriptor.getAction() == DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE) {
                this.enabled = true;
                this.isDefault = false;
            } else {
                this.enabled = false;
                this.isDefault = false;
            }
            this.name = categoryName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getName() {
            return this.name;
        }
    }
}

