/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DefinitionUpdateWorker;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.DefinitionsView;
import net.lukemurphey.nsia.web.views.Dialog;

public class DefinitionsUpdateView
extends View {
    public static final String VIEW_NAME = "definitions_update";

    public DefinitionsUpdateView() {
        super("Definitions/Update", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        DefinitionsUpdateView view = new DefinitionsUpdateView();
        return view.createURL(new Object[0]);
    }

    protected DefinitionUpdateWorker getWorkerIfRunning() {
        DefinitionUpdateWorker worker = null;
        Application.WorkerThreadDescriptor w = Application.getApplication().getWorkerThread("Definitions Update (unscheduled)");
        if (w != null) {
            worker = (DefinitionUpdateWorker)w.getWorkerThread();
        }
        return worker;
    }

    protected DefinitionUpdateWorker startUpdate(boolean force, int userID) throws DuplicateEntryException {
        DefinitionUpdateWorker worker = new DefinitionUpdateWorker(force);
        if (userID > -1) {
            Application.getApplication().addWorkerToQueue(worker, "Definitions Update (unscheduled)", userID);
            new Thread(worker).start();
        } else {
            Application.getApplication().addWorkerToQueue(worker, "Definitions Update (unscheduled)");
            new Thread(worker).start();
        }
        return worker;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        boolean isAjax;
        if (request.getParameter("Selected") != null && ("Cancel".equalsIgnoreCase(request.getParameter("Selected")) || "Ok".equalsIgnoreCase(request.getParameter("Selected")))) {
            response.sendRedirect(StandardViewList.getURL("definitions_list", new Object[0]));
            return true;
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Update definitions")) {
                context.addMessage("You do not have permission to update the definitions", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(DefinitionsView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        DefinitionUpdateWorker worker = this.getWorkerIfRunning();
        boolean startedNow = false;
        if (request.getParameter("Selected") != null && "Update".equalsIgnoreCase(request.getParameter("Selected")) && (worker == null || worker.getStatus() != WorkerThread.State.STARTED)) {
            try {
                worker = this.startUpdate(true, context.getSessionInfo().getUserId());
            }
            catch (DuplicateEntryException e) {
                worker = this.getWorkerIfRunning();
            }
            startedNow = true;
        }
        boolean bl = isAjax = request.getParameter("AJAX") != null;
        if (isAjax && worker == null) {
            response.getWriter().print(Dialog.getProgressDialog("Definition update complete", "Definition Update", 100, new Link("OK", this.createURL(new Object[0]))));
            return true;
        }
        if (isAjax && worker != null && worker.getStatus() == WorkerThread.State.STOPPED) {
            response.getWriter().print(Dialog.getProgressDialog(worker.getStatusDescription(), worker.getTaskDescription(), 100, new Link("OK", this.createURL(new Object[0]))));
            return true;
        }
        if (isAjax) {
            response.getWriter().print(Dialog.getProgressDialog(worker.getStatusDescription(), worker.getTaskDescription(), worker.getProgress(), new Link[0]));
            return true;
        }
        Shortcuts.addDashboardHeaders(request, response, data);
        if (worker != null && (startedNow || worker.getStatus() == WorkerThread.State.STARTING || worker.getStatus() == WorkerThread.State.STARTED)) {
            data.put("ajaxurl", String.valueOf(this.createURL(new Object[0])) + "?AJAX=True");
            data.put("title", "Definition Update");
            data.put("noajaxurl", this.createURL(new Object[0]));
            data.put("content", Dialog.getProgressDialog(worker.getStatusDescription(), worker.getTaskDescription(), worker.getProgress(), new Link[0]));
            response.getWriter().println(TemplateLoader.renderToString("AJAXProgressDialog.ftl", data));
            return true;
        }
        Dialog.getOptionDialog(response, context, data, "Do you want to update definitions now?", "Update Definitions", Dialog.DialogType.INFORMATION, new Link("Update", this.createURL(new Object[0])), new Link("Cancel", this.createURL(new Object[0])));
        return true;
    }
}

