/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.ReindexerWorker;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.SystemStatusView;

public class DefragmentIndexesView
extends View {
    public static final String VIEW_NAME = "defragment_indexes";

    public DefragmentIndexesView() {
        super("System/ReIndex", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        DefragmentIndexesView view = new DefragmentIndexesView();
        return view.createURL(new Object[0]);
    }

    private Application.WorkerThreadDescriptor getWorkerThread(boolean aliveThreadsOnly) {
        Application.WorkerThreadDescriptor[] workerThreads = Application.getApplication().getWorkerThreadQueue(aliveThreadsOnly);
        Application.WorkerThreadDescriptor backupWorker = null;
        int c = 0;
        while (c < workerThreads.length) {
            if (workerThreads[c].getWorkerThread().getTaskDescription().equalsIgnoreCase("Database Backup") && (workerThreads[c].getWorkerThread().getStatus() == WorkerThread.State.STARTED || workerThreads[c].getWorkerThread().getStatus() == WorkerThread.State.INITIALIZED)) {
                backupWorker = workerThreads[c];
            }
            ++c;
        }
        return backupWorker;
    }

    protected Application.WorkerThreadDescriptor startReindexerWorker() {
        ReindexerWorker worker = new ReindexerWorker();
        Application.WorkerThreadDescriptor desc = null;
        try {
            desc = Application.getApplication().addWorkerToQueue(worker, "Index Defragmenter (unscheduled)");
            Thread thread = new Thread(worker);
            thread.start();
        }
        catch (DuplicateEntryException duplicateEntryException) {
            // empty catch block
        }
        return desc;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        boolean isAjax;
        if ("Cancel".equalsIgnoreCase(request.getParameter("Selected"))) {
            response.sendRedirect(StandardViewList.getURL("main_dashboard", new Object[0]));
            return true;
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Reindex database")) {
                context.addMessage("You do not have permission to defragment the database indexes", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(SystemStatusView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        Application.WorkerThreadDescriptor worker = this.getWorkerThread(false);
        boolean startedNow = false;
        if ("Reindex".equalsIgnoreCase(request.getParameter("Selected"))) {
            startedNow = true;
            worker = this.startReindexerWorker();
            Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.DATABASE_INDEX_DEFRAGMENT_STARTED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID())));
        }
        boolean bl = isAjax = request.getParameter("AJAX") != null;
        if (isAjax && worker == null) {
            response.getWriter().print(Dialog.getProgressDialog("Reindexing complete", "Reindex Database", 100, new Link("OK", this.createURL(new Object[0]))));
            return true;
        }
        if (isAjax && worker != null && worker.getWorkerThread().getStatus() == WorkerThread.State.STOPPED) {
            response.getWriter().print(Dialog.getProgressDialog(worker.getWorkerThread().getStatusDescription(), worker.getWorkerThread().getTaskDescription(), 100, new Link("OK", this.createURL(new Object[0]))));
            return true;
        }
        if (isAjax) {
            response.getWriter().print(Dialog.getProgressDialog(worker.getWorkerThread().getStatusDescription(), worker.getWorkerThread().getTaskDescription(), worker.getWorkerThread().getProgress(), new Link[0]));
            return true;
        }
        Shortcuts.addDashboardHeaders(request, response, data);
        if (worker != null && (startedNow || worker.getWorkerThread().getStatus() == WorkerThread.State.STARTING || worker.getWorkerThread().getStatus() == WorkerThread.State.STARTED)) {
            data.put("ajaxurl", String.valueOf(this.createURL(new Object[0])) + "?AJAX=True");
            data.put("title", "Reindex Database");
            data.put("noajaxurl", this.createURL(new Object[0]));
            data.put("content", Dialog.getProgressDialog(worker.getWorkerThread().getStatusDescription(), worker.getWorkerThread().getTaskDescription(), worker.getWorkerThread().getProgress(), new Link[0]));
            response.getWriter().println(TemplateLoader.renderToString("AJAXProgressDialog.ftl", data));
            return true;
        }
        Dialog.getOptionDialog(response, context, data, "Are you sure you want to re-index the database?", "Reindex Database", Dialog.DialogType.INFORMATION, new Link("Reindex", this.createURL(new Object[0])), new Link("Cancel", this.createURL(new Object[0])));
        return true;
    }
}

