/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class Dialog {
    public static void getDialog(HttpServletResponse response, RequestContext context, Map<String, Object> data, String message, String title, DialogType type) throws ViewFailedException {
        String content = Dialog.getDialog(message, title, type, null);
        data.put("content", content);
        data.put("title", title);
        TemplateLoader.renderToResponse("CenteredDialog.ftl", data, response);
    }

    public static void getOptionDialog(HttpServletResponse response, RequestContext context, Map<String, Object> data, String message, String title, DialogType type, Link ... buttons) throws ViewFailedException {
        String content = Dialog.getOptionDialog(message, title, type, buttons);
        data.put("content", content);
        data.put("title", title);
        data.put("buttons", buttons);
        TemplateLoader.renderToResponse("CenteredDialog.ftl", data, response);
    }

    public static void getDialog(HttpServletResponse response, RequestContext context, Map<String, Object> data, String message, String title, DialogType type, Link suggested) throws ViewFailedException {
        String content = Dialog.getDialog(message, title, type, suggested);
        data.put("content", content);
        data.put("title", title);
        TemplateLoader.renderToResponse("CenteredDialog.ftl", data, response);
    }

    public static void getProgressDialog(HttpServletResponse response, RequestContext context, Map<String, Object> data, String message, String title, int progress, Link ... buttons) throws ViewFailedException {
        String content = Dialog.getProgressDialog(message, title, progress, new Link("Cancel", "Cancel"));
        data.put("content", content);
        data.put("title", title);
        data.put("buttons", buttons);
        data.put("progress", Math.min(progress, 100));
        TemplateLoader.renderToResponse("CenteredDialog.ftl", data, response);
    }

    public static String getProgressDialog(String message, String title, int progress, Link ... buttons) throws ViewFailedException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("title", title);
        data.put("message", message);
        data.put("buttons", buttons);
        data.put("progress", progress);
        data.put("icon", "/media/img/32_Information.gif");
        return TemplateLoader.renderToString("Dialog.ftl", data);
    }

    public static String getDialog(String message, String title, DialogType type) throws ViewFailedException {
        return Dialog.getDialog(message, title, type, null);
    }

    public static String getDialog(String message, String title, DialogType type, Link suggested) throws ViewFailedException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (type == DialogType.CRITICAL) {
            data.put("icon", "/media/img/32_Alert");
            data.put("warn", true);
        } else if (type == DialogType.WARNING) {
            data.put("icon", "/media/img/32_Warning");
            data.put("warn", true);
        } else {
            data.put("icon", "/media/img/32_Information");
        }
        data.put("title", title);
        data.put("message", message);
        if (suggested != null) {
            data.put("suggested", suggested);
        }
        return TemplateLoader.renderToString("Dialog.ftl", data);
    }

    public static String getOptionDialog(String message, String title, DialogType type, Link ... buttons) throws ViewFailedException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (type == DialogType.CRITICAL) {
            data.put("icon", "/media/img/32_Alert");
        } else if (type == DialogType.WARNING) {
            data.put("icon", "/media/img/32_Warning");
        } else {
            data.put("icon", "/media/img/32_Information");
        }
        data.put("title", title);
        data.put("message", message);
        data.put("buttons", buttons);
        return TemplateLoader.renderToString("Dialog.ftl", data);
    }

    public static enum DialogType {
        INFORMATION,
        WARNING,
        CRITICAL;

    }
}

