/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.eventlog.EventLogViewer;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class EventLogView
extends View {
    public static final int ENTRIES_PER_PAGE = 25;

    public EventLogView() {
        super("System/Eventlog", "event_log", new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        EventLogView view = new EventLogView();
        return view.createURL(new Object[0]);
    }

    private LogEntries getLogEntries(int severity, String contentFilter, int startEntry, boolean getNext) throws ViewFailedException {
        try {
            boolean getEventsAfterID = getNext;
            EventLogViewer logViewer = new EventLogViewer(Application.getApplication());
            EventLogViewer.EventLogFilter filter = new EventLogViewer.EventLogFilter(25);
            EventLogSeverity eventlogSeverity = null;
            if (severity == EventLogSeverity.EMERGENCY.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.EMERGENCY;
            } else if (severity == EventLogSeverity.CRITICAL.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.CRITICAL;
            } else if (severity == EventLogSeverity.ALERT.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.ALERT;
            } else if (severity == EventLogSeverity.ERROR.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.ERROR;
            } else if (severity == EventLogSeverity.NOTICE.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.NOTICE;
            } else if (severity == EventLogSeverity.WARNING.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.WARNING;
            } else if (severity == EventLogSeverity.INFORMATIONAL.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.INFORMATIONAL;
            } else if (severity == EventLogSeverity.DEBUG.getSyslogEquivalent()) {
                eventlogSeverity = EventLogSeverity.DEBUG;
            }
            if (eventlogSeverity != null) {
                filter.setSeverityFilter(eventlogSeverity);
            }
            if (contentFilter != null && !contentFilter.isEmpty()) {
                filter.setContentFilter(contentFilter);
            }
            int firstEntry = logViewer.getMinEntryID(contentFilter, eventlogSeverity);
            int lastEntry = logViewer.getMaxEntryID(contentFilter, eventlogSeverity);
            if (startEntry > -1) {
                filter.setEntryID(startEntry, getEventsAfterID);
            } else {
                filter.setEntryID(lastEntry, false);
            }
            EventLogViewer.EventLogEntry[] entries = logViewer.getEntries(filter);
            return new LogEntries(firstEntry, lastEntry, entries);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        data.put("title", "Event Log");
        Vector<Link> breadcrumbs = new Vector<Link>();
        breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
        breadcrumbs.add(new Link("Event Log", this.createURL(new Object[0])));
        data.put("breadcrumbs", breadcrumbs);
        data.put("menu", Menu.getSystemMenu(context));
        Shortcuts.addDashboardHeaders(request, response, data);
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Information.View", "View event logs")) {
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the event logs");
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        int startEntry = -1;
        boolean getEventsAfterID = false;
        boolean isFiltered = false;
        if (request.getParameter("Action") != null && request.getParameter("Action").equalsIgnoreCase("Previous")) {
            isFiltered = true;
            getEventsAfterID = false;
            try {
                startEntry = Integer.parseInt(request.getParameter("PrevID")) - 1;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else if (request.getParameter("Action") != null && request.getParameter("Action").equalsIgnoreCase("Next")) {
            isFiltered = true;
            getEventsAfterID = true;
            try {
                startEntry = Integer.parseInt(request.getParameter("Start"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int severity = -1;
        if (request.getParameter("Severity") != null) {
            isFiltered = true;
            try {
                severity = Integer.valueOf(request.getParameter("Severity"));
            }
            catch (NumberFormatException e) {
                context.addMessage("The severity value provided is invalid", SessionMessages.MessageSeverity.WARNING);
                severity = -1;
            }
        }
        String contentFilter = null;
        if (request.getParameter("Content") != null) {
            isFiltered = true;
            contentFilter = request.getParameter("Content");
        }
        data.put("severity", severity);
        data.put("contentfilter", contentFilter);
        data.put("emergency", (Object)EventLogSeverity.EMERGENCY);
        data.put("alert", (Object)EventLogSeverity.ALERT);
        data.put("critical", (Object)EventLogSeverity.CRITICAL);
        data.put("error", (Object)EventLogSeverity.ERROR);
        data.put("warning", (Object)EventLogSeverity.WARNING);
        data.put("notice", (Object)EventLogSeverity.NOTICE);
        data.put("informational", (Object)EventLogSeverity.INFORMATIONAL);
        data.put("debug", (Object)EventLogSeverity.DEBUG);
        if (!isFiltered) {
            Shortcuts.addDashboardHeaders(request, response, data, this.createURL(new Object[0]));
        }
        LogEntries entries = this.getLogEntries(severity, contentFilter, startEntry, getEventsAfterID);
        if (entries.logEntries.length > 0) {
            data.put("hasnext", entries.lastEntry > entries.logEntries[entries.logEntries.length - 1].getEntryID());
            data.put("hasprev", entries.firstEntry < entries.logEntries[0].getEntryID());
        }
        data.put("entries", entries.logEntries);
        TemplateLoader.renderToResponse("EventLog.ftl", data, response);
        return true;
    }

    private static class LogEntries {
        EventLogViewer.EventLogEntry[] logEntries;
        int firstEntry;
        int lastEntry;

        public LogEntries(int firstEntry, int lastEntry, EventLogViewer.EventLogEntry[] logEntries) {
            this.logEntries = logEntries;
            this.firstEntry = firstEntry;
            this.lastEntry = lastEntry;
        }
    }
}

