/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.GroupListView;

public class GroupDeleteView
extends View {
    public static final String VIEW_NAME = "group_delete";

    public GroupDeleteView() {
        super("Group/Delete", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(GroupManagement.GroupDescriptor group) throws URLInvalidException {
        GroupDeleteView view = new GroupDeleteView();
        return view.createURL(group.getGroupId());
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "Groups.Delete", "Delete user group")) {
                context.addMessage("You do not have permission to delete groups", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(GroupListView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        if (args.length >= 1) {
            int groupID;
            block10: {
                try {
                    groupID = Integer.valueOf(args[0]);
                }
                catch (NumberFormatException e) {
                    Dialog.getDialog(response, context, data, "The Group ID provided is not valid", "Group ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
                GroupManagement groupMgmt = new GroupManagement(Application.getApplication());
                if (!groupMgmt.deleteGroup(groupID)) break block10;
                Application.getApplication().logEvent(EventLogMessage.EventType.GROUP_DELETED, new EventLogField(EventLogField.FieldName.GROUP_ID, groupID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                context.addMessage("Group successfully deleted", SessionMessages.MessageSeverity.SUCCESS);
                response.sendRedirect(GroupListView.getURL());
                return true;
            }
            try {
                Application.getApplication().logEvent(EventLogMessage.EventType.GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.GROUP_ID, groupID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                Dialog.getDialog(response, context, data, "No group was found with the given ID", "Group Not Found", Dialog.DialogType.WARNING);
                return true;
            }
            catch (SQLException e) {
                throw new ViewFailedException(e);
            }
            catch (NoDatabaseConnectionException e) {
                throw new ViewFailedException(e);
            }
        }
        return true;
    }
}

