/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SiteGroupScanResult;
import net.lukemurphey.nsia.scan.ScanData;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class MainDashboardView
extends View {
    public static final String VIEW_NAME = "main_dashboard";

    public MainDashboardView() {
        super("", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        MainDashboardView view = new MainDashboardView();
        return view.createURL(new Object[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        SiteGroupScanResult[] results;
        data.put("title", "Main Dashboard");
        Vector<Link> breadcrumbs = new Vector<Link>();
        breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL(VIEW_NAME, new Object[0])));
        data.put("breadcrumbs", breadcrumbs);
        data.put("menu", Menu.getSystemMenu(context));
        Shortcuts.addDashboardHeaders(request, response, data, this.createURL(new Object[0]));
        Application.ApplicationStatusDescriptor system_status = Application.getApplication().getManagerStatus();
        data.put("system_status", system_status);
        ScanData scanData = new ScanData(Application.getApplication());
        try {
            results = scanData.getSiteGroupStatus();
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            throw new ViewFailedException(e);
        }
        Vector<SiteGroupScanResult> resultsFiltered = new Vector<SiteGroupScanResult>();
        int c = 0;
        while (c < results.length) {
            long objectID = results[c].getSiteGroupDescriptor().getObjectId();
            try {
                if (Shortcuts.canRead(context.getSessionInfo(), objectID, "Check site-group permissions for main-dashboard", false)) {
                    resultsFiltered.add(results[c]);
                }
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
            ++c;
        }
        results = new SiteGroupScanResult[resultsFiltered.size()];
        resultsFiltered.toArray(results);
        data.put("sitegroups", results);
        TemplateLoader.renderToResponse("MainDashboard.ftl", data, response);
        return true;
    }
}

