/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.RightDescriptor;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.GroupListView;
import net.lukemurphey.nsia.web.views.GroupView;
import net.lukemurphey.nsia.web.views.UserView;
import net.lukemurphey.nsia.web.views.UsersView;

public class RightsEditView
extends View {
    public static final String VIEW_NAME = "rights_editor";

    public RightsEditView() {
        super("Rights", VIEW_NAME, Pattern.compile("User|Group", 2), Pattern.compile("[0-9]+"));
    }

    public static String getURL(UserManagement.UserDescriptor user) throws URLInvalidException {
        RightsEditView view = new RightsEditView();
        return view.createURL("User", user.getUserID());
    }

    public static String getURL(GroupManagement.GroupDescriptor group) throws URLInvalidException {
        RightsEditView view = new RightsEditView();
        return view.createURL("Group", group.getGroupId());
    }

    private Right getRight(String right, String description, int subjectID, AccessControlDescriptor.Subject subjectType, AccessControl accessControl) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        RightDescriptor rightDescriptor = this.getRightDescriptor(right, description, subjectID, subjectType, accessControl);
        return new Right(right, description, rightDescriptor.getRight() == AccessControlDescriptor.Action.PERMIT);
    }

    private RightDescriptor getRightDescriptor(String right, String description, int subjectID, AccessControlDescriptor.Subject subjectType, AccessControl accessControl) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        RightDescriptor rightDescriptor = null;
        rightDescriptor = subjectType == AccessControlDescriptor.Subject.USER ? accessControl.getUserRight(subjectID, right, false) : accessControl.getGroupRight(subjectID, right);
        return rightDescriptor;
    }

    private boolean setRight(HttpServletRequest request, String rightName, int subjectId, AccessControlDescriptor.Subject subjectType, AccessControl accessControl, RequestContext context) throws NoSessionException, GeneralizedException, ViewFailedException {
        String allowed;
        AccessControlDescriptor.Action right;
        if (request.getParameter(rightName) != null) {
            right = AccessControlDescriptor.Action.PERMIT;
            allowed = "allow";
        } else {
            right = AccessControlDescriptor.Action.DENY;
            allowed = "deny";
        }
        RightDescriptor rightDescriptor = new RightDescriptor(right, subjectType, subjectId, rightName);
        try {
            if (accessControl.setRight(rightDescriptor)) {
                if (rightDescriptor.getSubjectType() == AccessControlDescriptor.Subject.USER) {
                    Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.VALUE, allowed), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, rightDescriptor.getSubjectId()));
                } else {
                    Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.VALUE, allowed), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.GROUP_ID, rightDescriptor.getSubjectId()));
                }
                return true;
            }
            return false;
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
    }

    private int setRights(RequestContext context, HttpServletRequest request, HttpServletResponse response, Tab tabIndex, int subjectId, AccessControlDescriptor.Subject subjectType) throws NoSessionException, GeneralizedException, ViewFailedException {
        AccessControl accessControl = new AccessControl(Application.getApplication());
        int setFailures = 0;
        boolean setPerformed = false;
        if (tabIndex == Tab.USER_MANAGEMENT || tabIndex == null) {
            if (!this.setRight(request, "Users.Add", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.Edit", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.View", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.Delete", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.Unlock", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.UpdatePassword", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.UpdateOwnPassword", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.Sessions.Delete", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Users.Sessions.View", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            setPerformed = true;
        }
        if (tabIndex == Tab.GROUP_MANAGEMENT || tabIndex == null) {
            if (!this.setRight(request, "Groups.Add", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Groups.View", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Groups.Edit", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Groups.Delete", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "Groups.Membership.Edit", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            setPerformed = true;
        }
        if (tabIndex == Tab.SITE_GROUP_MANAGEMENT || tabIndex == null) {
            if (!this.setRight(request, "SiteGroups.View", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "SiteGroups.Add", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "SiteGroups.Delete", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "SiteGroups.Edit", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            setPerformed = true;
        }
        if (tabIndex == Tab.SYSTEM_CONFIGURATION || tabIndex == null) {
            if (!this.setRight(request, "System.Information.View", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "System.Configuration.View", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "System.Configuration.Edit", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "System.Shutdown", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "System.ControlScanner", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            if (!this.setRight(request, "SiteGroups.ScanAllRules", subjectId, subjectType, accessControl, context)) {
                ++setFailures;
            }
            setPerformed = true;
        }
        if (setPerformed) {
            context.addMessage("Rights successfully updated", SessionMessages.MessageSeverity.SUCCESS);
        }
        return setFailures;
    }

    private Vector<RightsCategory> getRightsCategories(int subjectId, AccessControlDescriptor.Subject subjectType, AccessControl accessControl) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        Vector<RightsCategory> rights = new Vector<RightsCategory>();
        rights.add(new RightsCategory("User Management", this.getRights(Tab.USER_MANAGEMENT, subjectId, subjectType, accessControl), Tab.USER_MANAGEMENT.ordinal()));
        rights.add(new RightsCategory("Group Management", this.getRights(Tab.GROUP_MANAGEMENT, subjectId, subjectType, accessControl), Tab.GROUP_MANAGEMENT.ordinal()));
        rights.add(new RightsCategory("Site-Group Management", this.getRights(Tab.SITE_GROUP_MANAGEMENT, subjectId, subjectType, accessControl), Tab.SITE_GROUP_MANAGEMENT.ordinal()));
        rights.add(new RightsCategory("System Administration", this.getRights(Tab.SYSTEM_CONFIGURATION, subjectId, subjectType, accessControl), Tab.SYSTEM_CONFIGURATION.ordinal()));
        return rights;
    }

    private Vector<Right> getRights(Tab tabIndex, int subjectId, AccessControlDescriptor.Subject subjectType, AccessControl accessControl) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        Vector<Right> rights = new Vector<Right>();
        if (tabIndex == Tab.USER_MANAGEMENT) {
            rights.add(this.getRight("Users.Add", "Create New Users", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.Edit", "Edit Users", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.View", "View Users", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.Delete", "Delete Users", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.Unlock", "Unlock Accounts (due to repeated authentication attempts)", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.UpdatePassword", "Update Other's Password (applies only to the other users' accounts)", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.UpdateOwnPassword", "Update Account Details (applies only to the users' own account)", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.Sessions.Delete", "Delete Users' Sessions (kick users off)", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Users.Sessions.View", "View Users' Sessions (see who is logged in)", subjectId, subjectType, accessControl));
        } else if (tabIndex == Tab.GROUP_MANAGEMENT) {
            rights.add(this.getRight("Groups.Add", "Create New Groups", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Groups.View", "View Groups", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Groups.Edit", "Edit Groups", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Groups.Delete", "Delete Groups", subjectId, subjectType, accessControl));
            rights.add(this.getRight("Groups.Membership.Edit", "Manage Group Membership", subjectId, subjectType, accessControl));
        } else if (tabIndex == Tab.SITE_GROUP_MANAGEMENT) {
            rights.add(this.getRight("SiteGroups.View", "View Site-groups", subjectId, subjectType, accessControl));
            rights.add(this.getRight("SiteGroups.Add", "Create New Site-group", subjectId, subjectType, accessControl));
            rights.add(this.getRight("SiteGroups.Delete", "Delete Site-groups", subjectId, subjectType, accessControl));
            rights.add(this.getRight("SiteGroups.Edit", "Edit Site-groups", subjectId, subjectType, accessControl));
        } else {
            rights.add(this.getRight("System.Information.View", "View System Information and Status", subjectId, subjectType, accessControl));
            rights.add(this.getRight("System.Configuration.View", "View System Configuration", subjectId, subjectType, accessControl));
            rights.add(this.getRight("System.Configuration.Edit", "Modify System Configuration", subjectId, subjectType, accessControl));
            rights.add(this.getRight("System.Shutdown", "Shutdown the application", subjectId, subjectType, accessControl));
            rights.add(this.getRight("System.ControlScanner", "Start/Stop Scanner", subjectId, subjectType, accessControl));
            rights.add(this.getRight("SiteGroups.ScanAllRules", "Allow Gratuitous Scanning of All Rules", subjectId, subjectType, accessControl));
        }
        return rights;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        Vector<Right> rights;
        boolean isUser;
        block30: {
            Enum tabIndex;
            int subjectID;
            AccessControlDescriptor.Subject subjectType;
            block32: {
                Vector<Link> breadcrumbs;
                block31: {
                    block29: {
                        block28: {
                            isUser = true;
                            subjectType = AccessControlDescriptor.Subject.USER;
                            try {
                                subjectID = Integer.valueOf(args[1]);
                            }
                            catch (NumberFormatException e) {
                                Dialog.getDialog(response, context, data, "The identifier for the user or group is not a valid number.", "User or Group ID Invalid", Dialog.DialogType.WARNING);
                                return true;
                            }
                            if ("Group".equalsIgnoreCase(args[0])) {
                                isUser = false;
                                subjectType = AccessControlDescriptor.Subject.GROUP;
                            }
                            Shortcuts.addDashboardHeaders(request, response, data);
                            breadcrumbs = new Vector<Link>();
                            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
                            if (isUser) {
                                UserManagement.UserDescriptor user;
                                UserManagement userMgmt = new UserManagement(Application.getApplication());
                                try {
                                    user = userMgmt.getUserDescriptor(subjectID);
                                }
                                catch (NotFoundException e) {
                                    throw new ViewFailedException(e);
                                }
                                data.put("user", user);
                                breadcrumbs.add(new Link("User Management", UsersView.getURL()));
                                breadcrumbs.add(new Link("User: " + user.getUserName(), UserView.getURL(user)));
                                breadcrumbs.add(new Link("Rights", RightsEditView.getURL(user)));
                                data.put("menu", Menu.getUserMenuItems(context, user));
                            } else {
                                GroupManagement groupMgmt = new GroupManagement(Application.getApplication());
                                GroupManagement.GroupDescriptor group = groupMgmt.getGroupDescriptor(subjectID);
                                data.put("group", group);
                                breadcrumbs.add(new Link("Group Management", GroupListView.getURL()));
                                breadcrumbs.add(new Link("Group: " + group.getGroupName(), GroupView.getURL(group)));
                                breadcrumbs.add(new Link("Rights", RightsEditView.getURL(group)));
                                data.put("menu", Menu.getGroupMenuItems(context, group));
                            }
                            data.put("breadcrumbs", breadcrumbs);
                            data.put("title", "Rights Management");
                            if (!isUser || Shortcuts.hasRight(context.getSessionInfo(), "Users.View", "View rights for user ID " + subjectID)) break block28;
                            breadcrumbs.set(2, new Link("View User", UserView.getURL(subjectID)));
                            Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view user rights");
                            return true;
                        }
                        if (Shortcuts.hasRight(context.getSessionInfo(), "Groups.View", "View rights for group ID " + subjectID)) break block29;
                        breadcrumbs.set(2, new Link("View Group", GroupView.getURL(subjectID)));
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view group rights");
                        return true;
                    }
                    tabIndex = null;
                    if (request.getParameter("TabIndex") != null) {
                        try {
                            tabIndex = Tab.getFromOrdinal(Integer.valueOf(request.getParameter("TabIndex")));
                        }
                        catch (NumberFormatException group) {
                            // empty catch block
                        }
                    }
                    if (tabIndex != null) {
                        data.put("tabIndex", tabIndex.ordinal());
                    }
                    data.put("USER_MANAGEMENT", Tab.USER_MANAGEMENT.ordinal());
                    data.put("GROUP_MANAGEMENT", Tab.GROUP_MANAGEMENT.ordinal());
                    data.put("SYSTEM_CONFIGURATION", Tab.SYSTEM_CONFIGURATION.ordinal());
                    data.put("SITE_GROUP_MANAGEMENT", Tab.SITE_GROUP_MANAGEMENT.ordinal());
                    AccessControl accessControl = new AccessControl(Application.getApplication());
                    rights = null;
                    if (isUser) {
                        rights = this.getRights((Tab)tabIndex, subjectID, AccessControlDescriptor.Subject.USER, accessControl);
                        data.put("categories", this.getRightsCategories(subjectID, AccessControlDescriptor.Subject.USER, accessControl));
                    } else {
                        rights = this.getRights((Tab)tabIndex, subjectID, AccessControlDescriptor.Subject.GROUP, accessControl);
                        data.put("categories", this.getRightsCategories(subjectID, AccessControlDescriptor.Subject.GROUP, accessControl));
                    }
                    if (!"POST".equalsIgnoreCase(request.getMethod())) break block30;
                    if (!isUser || Shortcuts.hasRight(context.getSessionInfo(), "Users.Edit", "Edit rights for user ID " + subjectID)) break block31;
                    breadcrumbs.add(new Link("View User", UserView.getURL(subjectID)));
                    Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit user rights");
                    return true;
                }
                if (Shortcuts.hasRight(context.getSessionInfo(), "Groups.Edit", "Edit rights for group ID " + subjectID)) break block32;
                breadcrumbs.add(new Link("View Group", GroupView.getURL(subjectID)));
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit group rights");
                return true;
            }
            this.setRights(context, request, response, (Tab)tabIndex, subjectID, subjectType);
            if (subjectType == AccessControlDescriptor.Subject.GROUP) {
                response.sendRedirect(this.createURL("Group", subjectID));
            } else {
                response.sendRedirect(this.createURL("User", subjectID));
            }
            return true;
        }
        try {
            data.put("rights", rights);
            data.put("isUser", isUser);
            TemplateLoader.renderToResponse("RightsEditView.ftl", data, response);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (NotFoundException e) {
            Dialog.getDialog(response, context, data, e.getMessage(), "Not Found", Dialog.DialogType.WARNING);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        catch (NoSessionException e) {
            throw new ViewFailedException(e);
        }
        return true;
    }

    public static class Right {
        private String name;
        private String description;
        private boolean permitted;

        protected Right(String name, String description, boolean permitted) {
            this.name = name;
            this.description = description;
            this.permitted = permitted;
        }

        public boolean isPermitted() {
            return this.permitted;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class RightsCategory {
        private Vector<Right> rights = new Vector();
        private String name;
        private int index;

        public RightsCategory(String name, Vector<Right> rights, int index) {
            this.name = name;
            this.rights.addAll(rights);
            this.index = index;
        }

        public Collection<Right> getRights() {
            return this.rights;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum Tab {
        USER_MANAGEMENT,
        GROUP_MANAGEMENT,
        SITE_GROUP_MANAGEMENT,
        SYSTEM_CONFIGURATION;


        public static Tab getFromOrdinal(int ord) {
            Tab[] tabArray = Tab.values();
            int n = tabArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab = tabArray[n2];
                if (tab.ordinal() == ord) {
                    return tab;
                }
                ++n2;
            }
            return USER_MANAGEMENT;
        }
    }
}

