/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.MainDashboardView;
import net.lukemurphey.nsia.web.views.ServiceScanRuleEditView;
import net.lukemurphey.nsia.web.views.SiteGroupView;
import net.lukemurphey.nsia.web.views.WebDiscoveryRuleEditView;

public class RuleEditView
extends View {
    public static final String VIEW_NAME = "rule_editor";

    public RuleEditView() {
        super("Rule", VIEW_NAME, Pattern.compile("New|Edit", 2), Pattern.compile("[0-9]*"));
    }

    public static String getURL(SiteGroupManagement.SiteGroupDescriptor siteGroup) throws URLInvalidException {
        RuleEditView view = new RuleEditView();
        return String.valueOf(view.createURL("New")) + "?SiteGroupID=" + siteGroup.getGroupId();
    }

    public static String getURL(int ruleID) throws URLInvalidException {
        RuleEditView view = new RuleEditView();
        return view.createURL("Edit", ruleID);
    }

    public static String getURL(long ruleID) throws URLInvalidException {
        RuleEditView view = new RuleEditView();
        return view.createURL("Edit", ruleID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        int scanFrequencyValue;
        int scanFrequencyUnits;
        int siteGroupID;
        ScanRule rule;
        block35: {
            block37: {
                int frequency;
                block39: {
                    block38: {
                        block36: {
                            rule = null;
                            siteGroupID = 1;
                            SiteGroupManagement.SiteGroupDescriptor siteGroup = null;
                            try {
                                if (args.length >= 2) {
                                    int ruleID;
                                    try {
                                        ruleID = Integer.valueOf(args[1]);
                                    }
                                    catch (NumberFormatException e) {
                                        Dialog.getDialog(response, context, data, "The Rule ID provided is not valid", "Rule ID Invalid", Dialog.DialogType.WARNING);
                                        return true;
                                    }
                                    try {
                                        rule = ScanRuleLoader.getScanRule(ruleID);
                                    }
                                    catch (ScanRule.ScanRuleLoadFailureException e) {
                                        Dialog.getDialog(response, context, data, "No rule was found with the given ID", "Rule Not Found", Dialog.DialogType.WARNING);
                                        return true;
                                    }
                                    catch (NotFoundException e) {
                                        Dialog.getDialog(response, context, data, "No rule was found with the given ID", "Rule Not Found", Dialog.DialogType.WARNING);
                                        return true;
                                    }
                                    if (rule == null) {
                                        Dialog.getDialog(response, context, data, "No rule was found with the given ID", "Rule Not Found", Dialog.DialogType.WARNING);
                                        return true;
                                    }
                                    data.put("rule", rule);
                                }
                                if (rule != null) {
                                    try {
                                        siteGroupID = ScanRule.getAssociatedSiteGroupID(rule.getRuleId());
                                    }
                                    catch (NotFoundException e1) {
                                        Dialog.getDialog(response, context, data, "No Site-group exists with the given ID", "Site-group Not Found", Dialog.DialogType.WARNING);
                                        return true;
                                    }
                                }
                                try {
                                    siteGroupID = Integer.valueOf(request.getParameter("SiteGroupID"));
                                }
                                catch (NumberFormatException e1) {
                                    Shortcuts.addDashboardHeaders(request, response, data);
                                    Dialog.getDialog(response, context, data, "The Site-group ID provided is not valid", "Site-group ID Invalid", Dialog.DialogType.WARNING, new Link("Return to the Main Dashboard", MainDashboardView.getURL()));
                                    return true;
                                }
                                data.put("siteGroupID", siteGroupID);
                                try {
                                    SiteGroupManagement mgmr = new SiteGroupManagement(Application.getApplication());
                                    siteGroup = mgmr.getGroupDescriptor(siteGroupID);
                                }
                                catch (NotFoundException e1) {
                                    Dialog.getDialog(response, context, data, "The Site-group ID provided is not valid", "Site-group ID Invalid", Dialog.DialogType.WARNING);
                                    return true;
                                }
                                catch (NumberFormatException e1) {
                                    Dialog.getDialog(response, context, data, "The Site-group ID provided is not valid", "Site-group ID Invalid", Dialog.DialogType.WARNING);
                                    return true;
                                }
                                if (rule != null) {
                                    data.put("menu", Menu.getScanRuleMenu(context, siteGroup, rule.getRuleId()));
                                } else {
                                    data.put("menu", Menu.getSiteGroupMenu(context, siteGroup));
                                }
                                Vector<Link> breadcrumbs = new Vector<Link>();
                                breadcrumbs.add(new Link("Main Dashboard", MainDashboardView.getURL()));
                                breadcrumbs.add(new Link("Site-group: " + siteGroup.getGroupName(), SiteGroupView.getURL(siteGroupID)));
                                if (rule != null) {
                                    breadcrumbs.add(new Link("Edit Rule", this.createURL("Edit", rule.getRuleId())));
                                    data.put("title", "Rule: " + rule.getRuleType());
                                } else {
                                    breadcrumbs.add(new Link("New Rule", String.valueOf(this.createURL("New")) + "?SiteGroupID=" + siteGroupID));
                                    data.put("title", "New Rule");
                                }
                                data.put("breadcrumbs", breadcrumbs);
                                Shortcuts.addDashboardHeaders(request, response, data);
                                if ("Cancel".equalsIgnoreCase(request.getParameter("Action"))) {
                                    response.sendRedirect(SiteGroupView.getURL(siteGroupID));
                                    return true;
                                }
                                if (!Shortcuts.canModify(context.getSessionInfo(), siteGroup.getObjectId(), "Edit rule for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                                    Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to edit rules for this site-group");
                                    return true;
                                }
                            }
                            catch (SQLException e) {
                                throw new ViewFailedException(e);
                            }
                            catch (NoDatabaseConnectionException e) {
                                throw new ViewFailedException(e);
                            }
                            catch (InputValidationException e) {
                                throw new ViewFailedException(e);
                            }
                            catch (GeneralizedException e) {
                                throw new ViewFailedException(e);
                            }
                            scanFrequencyUnits = 0;
                            scanFrequencyValue = 0;
                            if (request.getParameter("ScanFrequencyUnits") == null || request.getParameter("ScanFrequencyValue") == null) break block36;
                            try {
                                scanFrequencyUnits = Integer.parseInt(request.getParameter("ScanFrequencyUnits"));
                                scanFrequencyValue = Integer.parseInt(request.getParameter("ScanFrequencyValue"));
                            }
                            catch (NumberFormatException e) {
                                scanFrequencyUnits = 0;
                                scanFrequencyValue = 0;
                            }
                            break block35;
                        }
                        if (scanFrequencyUnits != 0 && scanFrequencyValue != 0 || rule == null) break block37;
                        frequency = rule.getScanFrequency();
                        if (frequency != 0) break block38;
                        scanFrequencyUnits = 86400;
                        scanFrequencyValue = 1;
                        break block35;
                    }
                    if (frequency % 86400 != 0) break block39;
                    scanFrequencyUnits = 86400;
                    scanFrequencyValue = frequency / 86400;
                    break block35;
                }
                if (frequency % 3600 == 0) {
                    scanFrequencyUnits = 3600;
                    scanFrequencyValue = frequency / 3600;
                    break block35;
                } else if (frequency % 60 == 0) {
                    scanFrequencyUnits = 60;
                    scanFrequencyValue = frequency / 60;
                    break block35;
                } else {
                    scanFrequencyUnits = 1;
                    scanFrequencyValue = frequency;
                }
                break block35;
            }
            scanFrequencyUnits = 3600;
            scanFrequencyValue = 8;
        }
        data.put("scanFrequencyUnits", scanFrequencyUnits);
        data.put("scanFrequencyValue", scanFrequencyValue);
        String ruleType = "HTTP/Autodiscovery";
        ruleType = rule != null ? rule.getRuleType() : request.getParameter("RuleType");
        if (ruleType == null) {
            TemplateLoader.renderToResponse("SelectRule.ftl", data, response);
            return true;
        }
        if (ruleType.equals("HTTP/Autodiscovery")) {
            WebDiscoveryRuleEditView view = new WebDiscoveryRuleEditView();
            return view.process(request, response, context, args, data);
        }
        if (ruleType.equals("Service Scan")) {
            ServiceScanRuleEditView view = new ServiceScanRuleEditView();
            return view.process(request, response, context, args, data);
        }
        Dialog.getDialog(response, context, data, "The rule type provided is not recognized", "Rule Type Not Recognized", Dialog.DialogType.WARNING, new Link("Select Rule Type", String.valueOf(this.createURL("New")) + "?SiteGroupID=" + siteGroupID));
        return true;
    }
}

