/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.MainDashboardView;
import net.lukemurphey.nsia.web.views.SiteGroupView;

public class SiteGroupDeleteView
extends View {
    public static final String VIEW_NAME = "sitegroup_delete";

    public SiteGroupDeleteView() {
        super("SiteGroup/Delete", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(SiteGroupManagement.SiteGroupDescriptor siteGroup) throws URLInvalidException {
        SiteGroupDeleteView view = new SiteGroupDeleteView();
        return view.createURL(siteGroup.getGroupId());
    }

    public boolean deleteGroup(RequestContext context, int groupId) throws ViewFailedException, GeneralizedException {
        Application app;
        block7: {
            block6: {
                app = Application.getApplication();
                if (Shortcuts.hasRight(context.getSessionInfo(), "SiteGroups.Delete", "Delete site-group")) break block6;
                context.addMessage("You do not have permission to delete this site-group", SessionMessages.MessageSeverity.WARNING);
                return false;
            }
            SiteGroupManagement siteGroupManagement = new SiteGroupManagement(Application.getApplication());
            if (!siteGroupManagement.deleteGroup(groupId)) break block7;
            app.logEvent(EventLogMessage.EventType.SITE_GROUP_DELETED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
            return true;
        }
        try {
            app.logEvent(EventLogMessage.EventType.SITE_GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
            return true;
        }
        catch (SQLException e) {
            app.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            app.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            app.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new ViewFailedException(e);
        }
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        block6: {
            int siteGroupID = -1;
            if (args.length <= 0) {
                Dialog.getDialog(response, context, data, "The Site-group ID was not provided.", "Site-group ID Invalid", Dialog.DialogType.WARNING);
                return true;
            }
            try {
                siteGroupID = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                Dialog.getDialog(response, context, data, "The Site-group ID provided is invalid.", "Site-group ID Invalid", Dialog.DialogType.WARNING);
                return true;
            }
            try {
                if (this.deleteGroup(context, siteGroupID)) {
                    context.addMessage("Site-group successfully deleted", SessionMessages.MessageSeverity.SUCCESS);
                    break block6;
                }
                response.sendRedirect(SiteGroupView.getURL(siteGroupID));
                return true;
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
        }
        response.sendRedirect(MainDashboardView.getURL());
        return true;
    }
}

