/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationConfiguration;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class SystemConfigurationView
extends View {
    public SystemConfigurationView() {
        super("System/Configuration", "system_configuration", new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        SystemConfigurationView view = new SystemConfigurationView();
        return view.createURL(new Object[0]);
    }

    private long getAsLong(String value) throws FieldValidationFailedException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new FieldValidationFailedException("Value is not a valid number");
        }
    }

    private int getAsInt(String value) throws FieldValidationFailedException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new FieldValidationFailedException("Value is not a valid number");
        }
    }

    private boolean getAsBoolean(String value) throws FieldValidationFailedException {
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase("on")) {
            return true;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new FieldValidationFailedException("Value is not a valid boolean");
        }
    }

    private void processChanges(HttpServletRequest request, HttpServletResponse response, RequestContext context, Map<String, Object> data) throws ViewFailedException, FieldValidationFailedException {
        String name = request.getParameter("ParamID");
        String value = request.getParameter("ParamValue");
        if (name != null) {
            ApplicationConfiguration config = Application.getApplication().getApplicationConfiguration();
            boolean parameterSet = false;
            try {
                if (value != null && ParameterTitles.AUTH_LOGIN_AGGREGATION.equals(name)) {
                    config.setAuthenticationAttemptAggregationCount(this.getAsLong(value));
                    context.addMessage("Login aggregation updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (value != null && ParameterTitles.AUTH_LOGIN_BANNER.equals(name)) {
                    config.setLoginBanner(value);
                    context.addMessage("Login banner updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (value != null && ParameterTitles.AUTH_LOGIN_FAILURE_LIMIT.equals(name)) {
                    config.setAuthenticationAttemptLimit(this.getAsLong(value));
                    context.addMessage("Login failure limit updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (value != null && ParameterTitles.AUTH_PASSWORD_HASH_ITERATIONS.equals(name)) {
                    config.setHashIterations(this.getAsLong(value));
                    context.addMessage("Password hash iteration count updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (ParameterTitles.SERVER_AUTO_UPDATE_DEFINITIONS.equals(name)) {
                    config.setAutoDefinitionUpdating(this.getAsBoolean(value));
                    context.addMessage("Definitions auto-update updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (value != null && ParameterTitles.SERVER_PORT.equals(name)) {
                    config.setServerPort(this.getAsInt(value));
                    context.addMessage("Server port updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (ParameterTitles.SERVER_SSL_ENABLED.equals(name)) {
                    config.setSslEnabled(this.getAsBoolean(value));
                    context.addMessage("SSL setting updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (value != null && ParameterTitles.SERVER_SSL_KEY_PASSWORD.equals(name)) {
                    config.setSslKeyPassword(value);
                    context.addMessage("SSL key password updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (value != null && ParameterTitles.SERVER_SSL_PASSWORD.equals(name)) {
                    config.setSslPassword(value);
                    context.addMessage("SSL password updated", SessionMessages.MessageSeverity.SUCCESS);
                    parameterSet = true;
                } else if (!ParameterTitles.SERVER_WEB_ACCESS.equals(name)) {
                    if (ParameterTitles.SERVER_AUTO_UPDATE_DEFINITIONS.equals(name)) {
                        config.setAutoDefinitionUpdating(this.getAsBoolean(value));
                        context.addMessage("Definitions auto-update updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.SESSION_IDENTIFIER_LIFETIME.equals(name)) {
                        config.setSessionIdentifierLifetime(this.getAsLong(value));
                        context.addMessage("Session identifier lifetime updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.SESSION_INACTIVITY_THRESHOLD.equals(name)) {
                        config.setSessionInactivityThreshold(this.getAsLong(value));
                        context.addMessage("Session inactivity threshold updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.SESSION_LIFETIME.equals(name)) {
                        config.setSessionLifetime(this.getAsLong(value));
                        context.addMessage("Session lifetime updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.EMAIL_FROM_ADDRESS.equals(name)) {
                        try {
                            config.setEmailFromAddress(EmailAddress.getByAddress(value));
                            context.addMessage("Email from address updated", SessionMessages.MessageSeverity.SUCCESS);
                            parameterSet = true;
                        }
                        catch (UnknownHostException e) {
                            throw new FieldValidationFailedException("The host in the email address is invalid");
                        }
                        catch (InvalidLocalPartException e) {
                            throw new FieldValidationFailedException("Local part of the email address is invalid");
                        }
                    } else if (value != null && ParameterTitles.EMAIL_PASSWORD.equals(name)) {
                        config.setEmailPassword(value);
                        context.addMessage("Email password updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.EMAIL_SMTP_PORT.equals(name)) {
                        config.setEmailSMTPPort(this.getAsInt(value));
                        context.addMessage("Email SMTP port updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.EMAIL_SMTP_SERVER.equals(name)) {
                        config.setEmailSMTPServer(value);
                        context.addMessage("SMTP server updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.EMAIL_USERNAME.equals(name)) {
                        config.setEmailUsername(value);
                        context.addMessage("SMTP username updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.EMAIL_SMTP_ENCRYPTION.equals(name)) {
                        config.setEmailSMTPEncryption(GenericUtils.SMTPEncryption.valueOf(value));
                        context.addMessage("SMTP encryption setting updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (ParameterTitles.LOG_ENABLED.equals(name)) {
                        config.setLogServerEnabled(this.getAsBoolean(value));
                        context.addMessage("Log setting updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.LOG_FORMAT.equals(name)) {
                        config.setLogFormat(value);
                        context.addMessage("Log format updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.LOG_SERVER.equals(name)) {
                        config.setLogServerAddress(value);
                        context.addMessage("Log server updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.LOG_SERVER_PORT.equals(name)) {
                        config.setLogServerPort(this.getAsInt(value));
                        context.addMessage("Log server port updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.LOG_TRANSPORT.equals(name)) {
                        config.setLogServerProtocol(value);
                        context.addMessage("Log transport updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.LICENSE_KEY.equals(name)) {
                        config.setLicenseKey(value);
                        context.addMessage("License key updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (value != null && ParameterTitles.SCANNER_HTTP_THREADS.equals(name)) {
                        config.setMaxHTTPScanThreads(this.getAsInt(value));
                        context.addMessage("Scanner HTTP thread limit updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (ParameterTitles.SCANNER_RESCAN_EDITED_RULES.equals(name)) {
                        config.setRescanOnEditEnabled(this.getAsBoolean(value));
                        context.addMessage("Scanner re-scan setting updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    } else if (ParameterTitles.SCANNER_SCAN_DEFAULT_ENABLED.equals(name)) {
                        config.setDefaultScanningEnabled(this.getAsBoolean(value));
                        context.addMessage("Scanner default setting updated", SessionMessages.MessageSeverity.SUCCESS);
                        parameterSet = true;
                    }
                }
                if (parameterSet) {
                    Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.SYSTEM_CONFIGURATION_CHANGED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.PARAMETER, name), new EventLogField(EventLogField.FieldName.PARAMETER_VALUE, value)));
                }
            }
            catch (NoDatabaseConnectionException e) {
                throw new ViewFailedException(e);
            }
            catch (SQLException e) {
                throw new ViewFailedException(e);
            }
            catch (InputValidationException e) {
                throw new FieldValidationFailedException(e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            ApplicationConfiguration appConfig;
            block24: {
                data.put("title", "System Configuration");
                Vector<Link> breadcrumbs = new Vector<Link>();
                breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
                breadcrumbs.add(new Link("System Status", StandardViewList.getURL("system_status", new Object[0])));
                breadcrumbs.add(new Link("System Configuration", StandardViewList.getURL("system_configuration", new Object[0])));
                data.put("breadcrumbs", breadcrumbs);
                data.put("menu", Menu.getSystemMenu(context));
                Shortcuts.addDashboardHeaders(request, response, data);
                if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.View", "View system configuration")) {
                    Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the system configuration");
                    return true;
                }
                if (request.getMethod().equalsIgnoreCase("POST")) {
                    if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Change system configuration")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to change the system configuration");
                        return true;
                    }
                    try {
                        this.processChanges(request, response, context, data);
                    }
                    catch (FieldValidationFailedException e) {
                        context.getSessionMessages().addMessage(context.getSessionInfo(), e.getMessage(), SessionMessages.MessageSeverity.WARNING);
                        data.put("validation_failed", true);
                    }
                }
                appConfig = Application.getApplication().getApplicationConfiguration();
                Vector<Parameter> authentication_options = new Vector<Parameter>();
                authentication_options.add(new Parameter("Period to Aggregate Login Attempts", appConfig.getAuthenticationAttemptAggregationCount(), ParameterTitles.AUTH_LOGIN_AGGREGATION.getName(), ParameterType.INTEGER));
                authentication_options.add(new Parameter("Limit of Failed Authentication Attempts", appConfig.getAuthenticationAttemptLimit(), ParameterTitles.AUTH_LOGIN_FAILURE_LIMIT.getName(), ParameterType.INTEGER));
                authentication_options.add(new Parameter("Login Banner", appConfig.getLoginBanner(), ParameterTitles.AUTH_LOGIN_BANNER.getName(), ParameterType.MULTILINETEXT));
                authentication_options.add(new Parameter("Password Hash Iterations", appConfig.getHashIterations(), ParameterTitles.AUTH_PASSWORD_HASH_ITERATIONS.getName(), ParameterType.INTEGER));
                data.put("authentication_options", authentication_options);
                Vector<Parameter> session_options = new Vector<Parameter>();
                session_options.add(new Parameter("Session Inactivity Threshold", appConfig.getSessionInactivityThreshold(), ParameterTitles.SESSION_INACTIVITY_THRESHOLD.getName(), ParameterType.INTEGER));
                session_options.add(new Parameter("Maximum Session Lifetime", appConfig.getSessionLifetime(), ParameterTitles.SESSION_LIFETIME.getName(), ParameterType.INTEGER));
                session_options.add(new Parameter("Session Identifier Lifetime", appConfig.getSessionIdentifierLifetime(), ParameterTitles.SESSION_IDENTIFIER_LIFETIME.getName(), ParameterType.INTEGER));
                data.put("session_options", session_options);
                Vector<Parameter> server_options = new Vector<Parameter>();
                server_options.add(new Parameter("Web Server Port", appConfig.getServerPort(), ParameterTitles.SERVER_PORT.getName(), ParameterType.INTEGER));
                server_options.add(new Parameter("Enable SSL", appConfig.isSslEnabled(), ParameterTitles.SERVER_SSL_ENABLED.getName(), ParameterType.BOOL));
                server_options.add(new Parameter("SSL Password", appConfig.getSslPassword(), ParameterTitles.SERVER_SSL_PASSWORD.getName(), ParameterType.PASSWORD));
                server_options.add(new Parameter("SSL Key Password", appConfig.getSslKeyPassword(), ParameterTitles.SERVER_SSL_KEY_PASSWORD.getName(), ParameterType.PASSWORD));
                server_options.add(new Parameter("Auto-Update Definitions", appConfig.getAutoDefinitionUpdating(), ParameterTitles.SERVER_AUTO_UPDATE_DEFINITIONS.getName(), ParameterType.BOOL));
                data.put("server_options", server_options);
                Vector<Parameter> logging_options = new Vector<Parameter>();
                logging_options.add(new Parameter("Syslog Server Address", appConfig.getLogServerAddress(), ParameterTitles.LOG_SERVER.getName(), ParameterType.TEXT));
                logging_options.add(new Parameter("Syslog Server Port", appConfig.getLogServerPort(), ParameterTitles.LOG_SERVER_PORT.getName(), ParameterType.INTEGER));
                logging_options.add(new Parameter("Logging Enabled", appConfig.getLogServerEnabled(), ParameterTitles.LOG_ENABLED.getName(), ParameterType.BOOL));
                SelectParamValue[] log_formats = new SelectParamValue[]{new SelectParamValue("Native", "Native"), new SelectParamValue("Common Event Format", "Common Event Format (ArcSight)"), new SelectParamValue("Common Event Expression", "Common Event Expression (Splunk)")};
                logging_options.add(new Parameter("Log Format", appConfig.getLogFormat(), ParameterTitles.LOG_FORMAT.getName(), log_formats));
                SelectParamValue[] log_transport = new SelectParamValue[]{new SelectParamValue("UDP", "UDP"), new SelectParamValue("TCP", "TCP")};
                logging_options.add(new Parameter("Transport Protocol", appConfig.getLogServerProtocol(), ParameterTitles.LOG_TRANSPORT.getName(), log_transport));
                data.put("logging_options", logging_options);
                Vector<Parameter> license_options = new Vector<Parameter>();
                license_options.add(new Parameter("License Key", appConfig.getLicenseKey(), ParameterTitles.LICENSE_KEY.getName(), ParameterType.TEXT));
                data.put("license_options", license_options);
                Vector<Parameter> email_options = new Vector<Parameter>();
                try {
                    EmailAddress email = appConfig.getEmailFromAddress();
                    if (email == null) {
                        email_options.add(new Parameter("From Address", "", ParameterTitles.EMAIL_FROM_ADDRESS.getName(), ParameterType.TEXT));
                    } else {
                        email_options.add(new Parameter("From Address", appConfig.getEmailFromAddress().toString(), ParameterTitles.EMAIL_FROM_ADDRESS.getName(), ParameterType.TEXT));
                    }
                }
                catch (InvalidLocalPartException e) {
                    throw new ViewFailedException(e);
                }
                email_options.add(new Parameter("SMTP Server", appConfig.getEmailSMTPServer(), ParameterTitles.EMAIL_SMTP_SERVER.getName(), ParameterType.TEXT));
                email_options.add(new Parameter("SMTP Username", appConfig.getEmailUsername(), ParameterTitles.EMAIL_USERNAME.getName(), ParameterType.TEXT));
                email_options.add(new Parameter("SMTP Password", appConfig.getEmailPassword(), ParameterTitles.EMAIL_PASSWORD.getName(), ParameterType.PASSWORD));
                email_options.add(new Parameter("SMTP Port", appConfig.getEmailSMTPPort(), ParameterTitles.EMAIL_SMTP_PORT.getName(), ParameterType.INTEGER));
                SelectParamValue[] smtp_encryption = new SelectParamValue[]{new SelectParamValue(GenericUtils.SMTPEncryption.NONE.toString(), "None"), new SelectParamValue(GenericUtils.SMTPEncryption.STARTTLS.toString(), "StartTLS"), new SelectParamValue(GenericUtils.SMTPEncryption.TLS.toString(), "TLS"), new SelectParamValue(GenericUtils.SMTPEncryption.SSL.toString(), "SSL")};
                email_options.add(new Parameter("SMTP Encryption", appConfig.getEmailSMTPEncryption().toString(), ParameterTitles.EMAIL_SMTP_ENCRYPTION.getName(), smtp_encryption));
                data.put("email_options", email_options);
                if (request.getParameter("ParamID") != null) {
                    data.put("selected", request.getParameter("ParamID"));
                }
                Vector<Parameter> scanner_options = new Vector<Parameter>();
                scanner_options.add(new Parameter("Maximum HTTP Scan Threads", appConfig.getMaxHTTPScanThreads(), ParameterTitles.SCANNER_HTTP_THREADS.getName(), ParameterType.INTEGER));
                scanner_options.add(new Parameter("Re-Scan Rules Automatically After Editing", appConfig.isRescanOnEditEnabled(), ParameterTitles.SCANNER_RESCAN_EDITED_RULES.getName(), ParameterType.BOOL));
                scanner_options.add(new Parameter("Scanner Default State", appConfig.isDefaultScanningEnabled(), ParameterTitles.SCANNER_SCAN_DEFAULT_ENABLED.getName(), ParameterType.BOOL));
                data.put("scanner_options", scanner_options);
                if (context.getUser().getEmailAddress() != null) {
                    data.put("user_email", context.getUser().getEmailAddress());
                }
                data.put("email_from_address", appConfig.getEmailFromAddress());
                data.put("smtp_server", appConfig.getEmailSMTPServer());
                if (request.getParameter("SendTestEmail") != null) {
                    if (context.getUser().getEmailAddress() != null) {
                        try {
                            if (GenericUtils.sendMail(context.getUser().getEmailAddress(), "Test Email from NSIA", "This is a test email from ThreatFactor NSIA scanner")) {
                                context.addMessage("Email successfully sent to " + context.getUser().getEmailAddress(), SessionMessages.MessageSeverity.INFORMATION);
                                break block24;
                            }
                            context.addMessage("Email could not be sent to " + context.getUser().getEmailAddress(), SessionMessages.MessageSeverity.WARNING);
                        }
                        catch (MessagingException e) {
                            context.addMessage("Email could not be sent: " + e.getMessage(), SessionMessages.MessageSeverity.WARNING);
                        }
                    } else {
                        context.addMessage("Your account does not have an email address to send a test message to", SessionMessages.MessageSeverity.WARNING);
                    }
                }
            }
            data.put("license", appConfig.getLicense());
            TemplateLoader.renderToResponse("SystemConfiguration.ftl", data, response);
            return true;
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        catch (InvalidLocalPartException e) {
            throw new ViewFailedException(e);
        }
    }

    private static class FieldValidationFailedException
    extends Exception {
        private static final long serialVersionUID = 4279640126480506939L;

        public FieldValidationFailedException(String message) {
            super(message);
        }
    }

    public static class Parameter {
        private ParameterType type;
        private String name;
        private String id;
        private String value;
        private SelectParamValue[] select_params;

        public Parameter(String name, String value, String id, ParameterType type) {
            this.name = name;
            this.value = value;
            this.id = id;
            this.type = type;
        }

        public Parameter(String name, boolean value, String id, ParameterType type) {
            this.name = name;
            this.value = value ? "true" : "false";
            this.id = id;
            this.type = type;
        }

        public Parameter(String name, long value, String id, ParameterType type) {
            this.name = name;
            this.value = String.valueOf(value);
            this.id = id;
            this.type = type;
        }

        public Parameter(String name, int value, String id, ParameterType type) {
            this.name = name;
            this.value = String.valueOf(value);
            this.id = id;
            this.type = type;
        }

        public Parameter(String name, String value, String id, SelectParamValue[] select_params) {
            this.name = name;
            this.value = value;
            this.type = ParameterType.SELECT;
            this.id = id;
            this.select_params = select_params;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            if (this.value == null) {
                return "";
            }
            return this.value;
        }

        public String getId() {
            return this.id;
        }

        public SelectParamValue[] getSelectValues() {
            return this.select_params;
        }

        public boolean isBool() {
            return this.type == ParameterType.BOOL;
        }

        public boolean isInteger() {
            return this.type == ParameterType.INTEGER;
        }

        public boolean isMultiline() {
            return this.type == ParameterType.MULTILINETEXT;
        }

        public boolean isPassword() {
            return this.type == ParameterType.PASSWORD;
        }

        public boolean isSelect() {
            return this.type == ParameterType.SELECT;
        }

        public boolean isText() {
            return this.type == ParameterType.TEXT;
        }
    }

    private static enum ParameterTitles {
        AUTH_LOGIN_AGGREGATION("auth_login_aggregation"),
        AUTH_LOGIN_FAILURE_LIMIT("auth_login_failure_limit"),
        AUTH_LOGIN_BANNER("auth_login_banner"),
        AUTH_PASSWORD_HASH_ITERATIONS("auth_password_hash_iterations"),
        SESSION_INACTIVITY_THRESHOLD("session_inactivity_lifetime"),
        SESSION_LIFETIME("session_lifetime"),
        SESSION_IDENTIFIER_LIFETIME("session_identifier_lifetime"),
        SERVER_SSL_PASSWORD("server_ssl_password"),
        SERVER_PORT("server_port"),
        SERVER_WEB_ACCESS("server_web_access"),
        SERVER_SSL_ENABLED("server_ssl_enabled"),
        SERVER_SSL_KEY_PASSWORD("server_ssl_key_password"),
        SERVER_AUTO_UPDATE_DEFINITIONS("server_auto_update_definitions"),
        LOG_SERVER("log_server"),
        LOG_SERVER_PORT("log_server_port"),
        LOG_ENABLED("log_enabled"),
        LOG_FORMAT("log_format"),
        LOG_TRANSPORT("log_transport"),
        LICENSE_KEY("license_key"),
        EMAIL_FROM_ADDRESS("email_from_address"),
        EMAIL_SMTP_SERVER("email_smtp_server"),
        EMAIL_USERNAME("email_username"),
        EMAIL_PASSWORD("email_password"),
        EMAIL_SMTP_PORT("email_smtp_port"),
        EMAIL_SMTP_ENCRYPTION("email_smtp_encryption"),
        SCANNER_HTTP_THREADS("scanner_http_threads"),
        SCANNER_RESCAN_EDITED_RULES("scanner_rescan_edited_rules"),
        SCANNER_SCAN_DEFAULT_ENABLED("scanner_scan_default_enabled");

        private String name;

        private ParameterTitles(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(String name) {
            return this.name.equalsIgnoreCase(name);
        }
    }

    public static enum ParameterType {
        TEXT,
        MULTILINETEXT,
        BOOL,
        SELECT,
        INTEGER,
        PASSWORD;

    }

    public static class SelectParamValue {
        String name;
        String value;

        public SelectParamValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

