/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.TaskListView;

public class TaskStopView
extends View {
    public TaskStopView() {
        super("System/Task/Stop", "task_stop", Pattern.compile(".*", 2));
    }

    public static String getURL(String taskName) throws URLInvalidException {
        TaskStopView view = new TaskStopView();
        return view.createURL(taskName);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        Shortcuts.addDashboardHeaders(request, response, data);
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Stop background task")) {
                context.addMessage("You do not have permission to stop running tasks.", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(TaskListView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        if (args.length <= 0) {
            Dialog.getDialog(response, context, data, "The name of the task to terminate was not provided.", "Task Name Not Provided", Dialog.DialogType.WARNING, new Link("Return to the list of running tasks", StandardViewList.getURL("task_list", new Object[0])));
            return true;
        }
        String name = args[0];
        Application.WorkerThreadDescriptor thread = this.getWorkerThread(name, true);
        if (thread == null) {
            Dialog.getDialog(response, context, data, "No running task was found with the given name.", "Task Not Found", Dialog.DialogType.WARNING, new Link("Return to the list of running tasks", StandardViewList.getURL("task_list", new Object[0])));
            return true;
        }
        thread.getWorkerThread().terminate();
        context.addMessage("Task was given terminate command", SessionMessages.MessageSeverity.SUCCESS);
        response.sendRedirect(StandardViewList.getURL("task_list", new Object[0]));
        return true;
    }

    private Application.WorkerThreadDescriptor getWorkerThread(String name, boolean aliveThreadsOnly) {
        Application.WorkerThreadDescriptor[] workerThreads = Application.getApplication().getWorkerThreadQueue(aliveThreadsOnly);
        Application.WorkerThreadDescriptor worker = null;
        int c = 0;
        while (c < workerThreads.length) {
            if (workerThreads[c].getUniqueName().equalsIgnoreCase(name) && (workerThreads[c].getWorkerThread().getStatus() == WorkerThread.State.STARTED || workerThreads[c].getWorkerThread().getStatus() == WorkerThread.State.INITIALIZED)) {
                worker = workerThreads[c];
            }
            ++c;
        }
        return worker;
    }
}

