/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DisallowedOperationException;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.forms.EmailAddressValidator;
import net.lukemurphey.nsia.web.forms.Field;
import net.lukemurphey.nsia.web.forms.FieldError;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.forms.Form;
import net.lukemurphey.nsia.web.forms.PasswordValidator;
import net.lukemurphey.nsia.web.forms.PatternValidator;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.MainDashboardView;
import net.lukemurphey.nsia.web.views.UserView;
import net.lukemurphey.nsia.web.views.UsersView;

public class UserEditView
extends View {
    public static final String VIEW_NAME = "user_editor";

    public UserEditView() {
        super("User", VIEW_NAME, Pattern.compile("(New)|(Edit)", 2), Pattern.compile("[0-9]*"));
    }

    public static String getURL(UserManagement.UserDescriptor user) throws URLInvalidException {
        UserEditView view = new UserEditView();
        return view.createURL("Edit", user.getUserID());
    }

    public static String getURL() throws URLInvalidException {
        UserEditView view = new UserEditView();
        return view.createURL("New");
    }

    private Form getUserEditForm(boolean includePasswordFields) {
        UserEditForm form = new UserEditForm();
        form.addField(new Field("Username", new PatternValidator(Pattern.compile("[-A-Z0-9a-z_ .]{1,32}", 2), "Username is not valid")));
        form.addField(new Field("Fullname", new PatternValidator(Pattern.compile("[-A-Z0-9a-z_ ().]{1,128}", 2), "Full name is not valid")));
        form.addField(new Field("EmailAddress", new EmailAddressValidator("Email address is not valid")));
        if (includePasswordFields) {
            form.addField(new Field("Password", new PasswordValidator()));
            form.addField(new Field("PasswordConfirm"));
        }
        form.addField(new Field("Unrestricted"));
        return form;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performActions(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data, UserManagement.UserDescriptor user) throws ViewFailedException, IOException, URLInvalidException, ViewNotFoundException, DisallowedOperationException {
        try {
            UserManagement userManager = new UserManagement(Application.getApplication());
            if (!"POST".equalsIgnoreCase(request.getMethod())) return false;
            Form form = args.length > 0 && args[0].equalsIgnoreCase("Edit") ? this.getUserEditForm(false) : this.getUserEditForm(true);
            FieldErrors errors = form.validate(request);
            if (errors.size() > 0) {
                data.put("form_errors", errors);
                return false;
            }
            String name = request.getParameter("Username");
            String fullname = request.getParameter("Fullname");
            EmailAddress emailAddress = EmailAddress.getByAddress(request.getParameter("EmailAddress"));
            String password = request.getParameter("Password");
            boolean unrestricted = false;
            if (request.getParameter("Unrestricted") != null) {
                unrestricted = true;
            }
            try {
                if (user == null) {
                    if (!context.getUser().isUnrestricted() && unrestricted) {
                        Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, "Attempt to create unrestricted account from restricted account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserName()));
                        throw new DisallowedOperationException("Restricted users cannot create unrestricted accounts");
                    }
                    if (userManager.getUserID(name) != -1) {
                        context.addMessage("User name already exists", SessionMessages.MessageSeverity.WARNING);
                        return false;
                    }
                    int userID = userManager.addAccount(name, fullname, password, emailAddress, unrestricted);
                    if (userID > 0) {
                        user = userManager.getUserDescriptor(userID);
                        Application.getApplication().logEvent(EventLogMessage.EventType.USER_ADDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userID), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, name));
                        context.addMessage("User created successfully", SessionMessages.MessageSeverity.SUCCESS);
                        response.sendRedirect(UserView.getURL(user));
                        return true;
                    }
                    Application.getApplication().logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add user account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, name));
                    context.addMessage("User was not created successfully", SessionMessages.MessageSeverity.WARNING);
                    return false;
                }
                if (unrestricted && !context.getUser().isUnrestricted()) {
                    Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, user.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()));
                    throw new DisallowedOperationException("Restricted users cannot create unrestricted accounts");
                }
                if (userManager.updateAccountEx(user.getUserID(), name, fullname, emailAddress, unrestricted)) {
                    Application.getApplication().logEvent(EventLogMessage.EventType.USER_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, user.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()));
                    context.addMessage("User updated successfully", SessionMessages.MessageSeverity.SUCCESS);
                    response.sendRedirect(UserView.getURL(user));
                    return true;
                }
                Application.getApplication().logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Update user account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, user.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()));
                context.addMessage("User could not be updated", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(UserView.getURL(user));
                return true;
            }
            catch (InputValidationException e) {
                throw new ViewFailedException(e);
            }
        }
        catch (SQLException e2) {
            throw new ViewFailedException(e2);
        }
        catch (NoDatabaseConnectionException e3) {
            throw new ViewFailedException(e3);
        }
        catch (NoSuchAlgorithmException e4) {
            throw new ViewFailedException(e4);
        }
        catch (NotFoundException e5) {
            throw new ViewFailedException(e5);
        }
        catch (InvalidLocalPartException e6) {
            throw new ViewFailedException(e6);
        }
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        Vector<Link> breadcrumbs;
        UserManagement.UserDescriptor user;
        block20: {
            block19: {
                user = null;
                if (args.length >= 2) {
                    int userID;
                    try {
                        userID = Integer.valueOf(args[1]);
                    }
                    catch (NumberFormatException e) {
                        Dialog.getDialog(response, context, data, "The User ID provided is not valid", "User ID Invalid", Dialog.DialogType.WARNING);
                        return true;
                    }
                    UserManagement userMgmt = new UserManagement(Application.getApplication());
                    try {
                        user = userMgmt.getUserDescriptor(userID);
                    }
                    catch (NotFoundException e) {
                        Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
                        return true;
                    }
                    catch (SQLException e) {
                        throw new ViewFailedException(e);
                    }
                    catch (NoDatabaseConnectionException e) {
                        throw new ViewFailedException(e);
                    }
                    if (user == null) {
                        Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
                        return true;
                    }
                    data.put("user", user);
                }
                data.put("menu", Menu.getUserMenu(context, user));
                breadcrumbs = new Vector<Link>();
                breadcrumbs.add(new Link("Main Dashboard", MainDashboardView.getURL()));
                breadcrumbs.add(new Link("User Management", UsersView.getURL()));
                Shortcuts.addDashboardHeaders(request, response, data);
                data.put("breadcrumbs", breadcrumbs);
                try {
                    if (user != null) break block19;
                    if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.Add", "Create new user account")) {
                        breadcrumbs.add(new Link("New User", this.createURL("New")));
                        data.put("breadcrumbs", breadcrumbs);
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to create users");
                        return true;
                    }
                }
                catch (GeneralizedException e) {
                    throw new ViewFailedException(e);
                }
            }
            if (context.getUser().getUserID() != user.getUserID() || Shortcuts.hasRight(context.getSessionInfo(), "Users.UpdateOwnPassword", "Update user's own account")) break block20;
            Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit your account");
            return true;
        }
        if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.Edit", "Update another user's account")) {
            breadcrumbs.add(new Link("View User", UserView.getURL(user)));
            breadcrumbs.add(new Link("Edit User", this.createURL("Edit", user.getUserID())));
            data.put("breadcrumbs", breadcrumbs);
            Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit users");
            return true;
        }
        try {
            if (this.performActions(request, response, context, args, data, user)) {
                return true;
            }
        }
        catch (DisallowedOperationException e) {
            context.addMessage(e.getMessage(), SessionMessages.MessageSeverity.WARNING);
        }
        if (user != null) {
            breadcrumbs.add(new Link("View User: " + user.getUserName(), UserView.getURL(user)));
            breadcrumbs.add(new Link("Edit User", this.createURL("Edit", user.getUserID())));
            data.put("title", "User: " + user);
        } else {
            breadcrumbs.add(new Link("New User", this.createURL("New")));
            data.put("title", "New User");
        }
        data.put("breadcrumbs", breadcrumbs);
        TemplateLoader.renderToResponse("UserEdit.ftl", data, response);
        return true;
    }

    private static class UserEditForm
    extends Form {
        private UserEditForm() {
        }

        @Override
        public FieldErrors validate(HttpServletRequest request) {
            FieldErrors errors = super.validate(request);
            if (!errors.isEmpty()) {
                return errors;
            }
            if (request.getParameter("Password") != null && !request.getParameter("Password").equalsIgnoreCase(request.getParameter("PasswordConfirm"))) {
                errors.put(new FieldError("PasswordConfirm", request.getParameter("PasswordConfirm"), "The passwords are not identical"));
            }
            return errors;
        }
    }
}

