/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.UserView;

public class UserGroupMembershipEditView
extends View {
    public static final String VIEW_NAME = "user_edit_membership";

    public UserGroupMembershipEditView() {
        super("User/Edit/Membership", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(UserManagement.UserDescriptor user) throws URLInvalidException {
        UserGroupMembershipEditView view = new UserGroupMembershipEditView();
        return view.createURL(user.getUserID());
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        int userID;
        UserManagement userMgmt = new UserManagement(Application.getApplication());
        UserManagement.UserDescriptor user = null;
        try {
            userID = Integer.valueOf(args[0]);
            user = userMgmt.getUserDescriptor(userID);
        }
        catch (NumberFormatException e) {
            Dialog.getDialog(response, context, data, "User ID is not valid", "User ID Invalid", Dialog.DialogType.WARNING);
            return true;
        }
        catch (NotFoundException e) {
            Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "Groups.Membership.Edit", "Edit group membership for user ID " + user.getUserID() + " (" + user.getUserName() + ")")) {
                context.addMessage("You do not have permission to update the group membership for user accounts", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(UserView.getURL(user));
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        String includedGroupString = request.getParameter("IncludedGroups");
        String[] includedGroups = includedGroupString.split(",");
        GroupManagement groupManager = new GroupManagement(Application.getApplication());
        boolean updated = false;
        int c = 0;
        while (c < includedGroups.length) {
            int groupId = -1;
            try {
                groupId = Integer.parseInt(includedGroups[c]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (groupId >= 0) {
                    if (request.getParameter(includedGroups[c]) != null) {
                        groupManager.addUserToGroup(userID, groupId);
                        updated = true;
                        Application.getApplication().logEvent(EventLogMessage.EventType.USER_ADDED_TO_GROUP, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getSessionInfo().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getSessionInfo().getUserId()));
                    } else {
                        groupManager.removeUserFromGroup(userID, groupId);
                        updated = true;
                        Application.getApplication().logEvent(EventLogMessage.EventType.USER_REMOVED_FROM_GROUP, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getSessionInfo().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getSessionInfo().getUserId()));
                    }
                }
            }
            catch (SQLException e) {
                throw new ViewFailedException(e);
            }
            catch (NotFoundException e) {
                throw new ViewFailedException(e);
            }
            catch (NoDatabaseConnectionException e) {
                throw new ViewFailedException(e);
            }
            ++c;
        }
        if (updated) {
            context.addMessage("Group membership updated", SessionMessages.MessageSeverity.SUCCESS);
        }
        response.sendRedirect(UserView.getURL(user));
        return true;
    }
}

