/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.UserView;

public class UserUnlockView
extends View {
    public static final String VIEW_NAME = "user_unlock";

    public UserUnlockView() {
        super("User/Unlock", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(UserManagement.UserDescriptor user) throws URLInvalidException {
        UserUnlockView view = new UserUnlockView();
        return view.createURL(user.getUserID());
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        int userID;
        UserManagement userMgmt = new UserManagement(Application.getApplication());
        UserManagement.UserDescriptor user = null;
        try {
            userID = Integer.valueOf(args[0]);
            user = userMgmt.getUserDescriptor(userID);
        }
        catch (NumberFormatException e) {
            Dialog.getDialog(response, context, data, "The given user ID is invalid", "User ID Invalid", Dialog.DialogType.WARNING);
            return true;
        }
        catch (NotFoundException e) {
            Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        if (user == null) {
            Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        data.put("user", user);
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.Unlock", "Unlock user account")) {
                context.addMessage("You do not have permission to unlock user accounts", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(UserView.getURL(userID));
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        try {
            userMgmt.clearAuthFailedCount(user);
            Application.getApplication().logEvent(EventLogMessage.EventType.USER_NAME_UNLOCKED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, user.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
            context.addMessage("User account unlocked", SessionMessages.MessageSeverity.SUCCESS);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NumericalOverflowException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        response.sendRedirect(UserView.getURL(user));
        return true;
    }
}

