/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.NameIntPair;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.HttpSeekingScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;

public class WebDiscoveryScanResultView
extends View {
    public static final String VIEW_NAME = "scan_result";
    private static int RESULTS_PER_PAGE = 30;

    public WebDiscoveryScanResultView() {
        super("ScanResult", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        Vector<NameIntPair> definitionMatches;
        HttpSeekingScanResult scanResult = (HttpSeekingScanResult)data.get("scanResult");
        String scanRuleFilter = request.getParameter("RuleFilter");
        String contentTypeFilter = request.getParameter("ContentTypeFilter");
        HttpDefinitionScanResult.SignatureScanResultFilter filter = contentTypeFilter != null && contentTypeFilter.equalsIgnoreCase("[unknown]") ? new HttpDefinitionScanResult.SignatureScanResultFilter("", scanRuleFilter) : new HttpDefinitionScanResult.SignatureScanResultFilter(contentTypeFilter, scanRuleFilter);
        HttpDefinitionScanResult[] findings = scanResult.getFindings();
        MaxMinCount maxMinCount = null;
        long firstScanResultId = -1L;
        long lastScanResultId = -1L;
        long startEntry = -1L;
        boolean resultsBefore = false;
        try {
            String action;
            if (request.getParameter("S") != null) {
                firstScanResultId = Long.valueOf(request.getParameter("S"));
            }
            if (request.getParameter("E") != null) {
                lastScanResultId = Long.valueOf(request.getParameter("E"));
            }
            if ((action = request.getParameter("Action")) != null && action.equalsIgnoreCase("Previous")) {
                startEntry = firstScanResultId;
                resultsBefore = true;
            } else if (action != null && action.equalsIgnoreCase("Next")) {
                startEntry = lastScanResultId;
                resultsBefore = false;
            }
        }
        catch (NumberFormatException e) {
            Dialog.getDialog(response, context, data, "The result identifier provided is invalid", "Invalid Parameter", Dialog.DialogType.WARNING);
            return true;
        }
        try {
            maxMinCount = HttpDefinitionScanResult.getScanResultInfo(scanResult.getScanResultID(), filter, Application.getApplication());
            findings = scanResult.getFindings(startEntry, RESULTS_PER_PAGE, filter, resultsBefore);
            if (findings.length > 0) {
                firstScanResultId = findings[0].getScanResultID();
                lastScanResultId = findings[findings.length - 1].getScanResultID();
            }
        }
        catch (Exception e) {
            throw new ViewFailedException(e);
        }
        try {
            definitionMatches = HttpDefinitionScanResult.getSignatureMatches(scanResult.getScanResultID());
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        Vector<NameIntPair> contentTypesCount = scanResult.getDiscoveredContentTypes();
        data.put("contentTypesCount", contentTypesCount);
        data.put("definitionMatches", definitionMatches);
        data.put("firstScanResultID", firstScanResultId);
        data.put("lastScanResultID", lastScanResultId);
        data.put("scanRuleFilter", scanRuleFilter);
        data.put("contentTypeFilter", contentTypeFilter);
        data.put("maxMinCount", maxMinCount);
        data.put("findings", findings);
        data.put("RESULTS_PER_PAGE", RESULTS_PER_PAGE);
        data.put("PENDING", ScanResultCode.PENDING);
        data.put("READY", ScanResultCode.READY);
        data.put("SCAN_COMPLETED", ScanResultCode.SCAN_COMPLETED);
        data.put("SCAN_FAILED", ScanResultCode.SCAN_FAILED);
        data.put("UNREADY", ScanResultCode.UNREADY);
        data.put("HIGH", (Object)Definition.Severity.HIGH);
        data.put("MEDIUM", (Object)Definition.Severity.MEDIUM);
        data.put("LOW", (Object)Definition.Severity.LOW);
        data.put("UNDEFINED", (Object)Definition.Severity.UNDEFINED);
        TemplateLoader.renderToResponse("WebDiscoveryResult.ftl", data, response);
        return true;
    }

    static class ContentTypeCount {
        public String contentType;
        public int count = 1;

        public ContentTypeCount(String contentType) {
            this.contentType = contentType;
        }
    }

    static class SignatureMatchCount {
        public String name;
        public int count = 1;

        public SignatureMatchCount(String name) {
            this.name = name;
        }
    }
}

