/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.FirewallRule;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InetAddressRange;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.trustBoundary.ApiFirewallManagement;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcFirewallManagement
extends XmlrpcHandler {
    private ApiFirewallManagement firewallManager;

    public XmlrpcFirewallManagement(Application appRes) {
        super(appRes);
        this.firewallManager = new ApiFirewallManagement(this.appRes);
    }

    public void setDefaultDeny(String sessionIdentifier, boolean denyByDefault) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.firewallManager.setDefaultDeny(sessionIdentifier, denyByDefault);
    }

    public boolean getDefaultDeny(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.firewallManager.getDefaultDeny(sessionIdentifier);
    }

    public Vector<Hashtable<String, Object>> getFirewallRules(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        FirewallRule[] rules = this.firewallManager.getFirewallRules(sessionIdentifier);
        Vector<Hashtable<String, Object>> firewallRules = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < rules.length) {
            firewallRules.add(this.convertRuleToVector(rules[c]));
            ++c;
        }
        return firewallRules;
    }

    public int isAllowed(String sessionIdentifier, String address) throws UnknownHostException, InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.firewallManager.isAllowed(sessionIdentifier, address).ordinal();
    }

    public Vector<Hashtable<String, Object>> getMatchingFirewallRules(String sessionIdentifier, String address) throws UnknownHostException, InsufficientPermissionException, GeneralizedException, NoSessionException {
        FirewallRule[] rules = this.firewallManager.getMatchingFirewallRules(sessionIdentifier, address);
        Vector<Hashtable<String, Object>> firewallRules = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < rules.length) {
            firewallRules.add(this.convertRuleToVector(rules[c]));
            ++c;
        }
        return firewallRules;
    }

    public Hashtable<String, Object> getFirewallRuleById(String sessionIdentifier, int ruleId) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        return this.convertRuleToVector(this.firewallManager.getFirewallRuleById(sessionIdentifier, ruleId));
    }

    public void addFirewallRule(String sessionIdentifier, String startAddressStr, String endAddressStr, boolean ruleDeny, Date expireDate) throws DuplicateEntryException, SQLException, InsufficientPermissionException, GeneralizedException, UnknownHostException, NoSessionException {
        this.firewallManager.addFirewallRule(sessionIdentifier, startAddressStr, endAddressStr, ruleDeny, expireDate);
    }

    public void removeFirewallRule(String sessionIdentifier, int ruleId) throws DuplicateEntryException, SQLException, InsufficientPermissionException, GeneralizedException, UnknownHostException, NoSessionException {
        this.firewallManager.removeFirewallRule(sessionIdentifier, ruleId);
    }

    private Hashtable<String, Object> convertRuleToVector(FirewallRule firewallRule) {
        Hashtable<String, Object> rulesDesc = new Hashtable<String, Object>();
        InetAddressRange addressRange = firewallRule.getAddressRange();
        rulesDesc.put("StartAddress", addressRange.getStartAddressString());
        rulesDesc.put("EndAddress", addressRange.getEndAddressString());
        rulesDesc.put("RuleID", firewallRule.getRuleId());
        rulesDesc.put("ExpireTime", firewallRule.getRuleExpireTime());
        rulesDesc.put("DenyRule", firewallRule.isDenyRule());
        return rulesDesc;
    }
}

