/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationStateMonitor;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.trustBoundary.ApiSystem;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcSystem
extends XmlrpcHandler {
    private ApiSystem system;

    public XmlrpcSystem(Application appRes) {
        super(appRes);
        this.system = new ApiSystem(appRes);
    }

    public String getDatabaseConnectionInfo(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getDatabaseConnectionInfo(sessionIdentifier);
    }

    public String getDatabaseDriver(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getDatabaseDriver(sessionIdentifier);
    }

    public String getJvmVendor(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getJvmVendor(sessionIdentifier);
    }

    public String getJvmVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getJvmVersion(sessionIdentifier);
    }

    public double getMaxMemory(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getMaxMemory(sessionIdentifier);
    }

    public String getOperatingSystemName(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getOperatingSystemName(sessionIdentifier);
    }

    public String getOperatingSystemVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getOperatingSystemVersion(sessionIdentifier);
    }

    public String getPlatformArch(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getPlatformArch(sessionIdentifier);
    }

    public int getProcessorCount(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getProcessorCount(sessionIdentifier);
    }

    public int getServerPort(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getServerPort(sessionIdentifier);
    }

    public boolean getSslEnabled(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getSslEnabled(sessionIdentifier);
    }

    public int getThreadCount(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getThreadCount(sessionIdentifier);
    }

    public int getDatabaseConnectionCount(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getDatabaseConnectionCount(sessionIdentifier);
    }

    public double getUptime(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getUptime(sessionIdentifier);
    }

    public double getUsedMemory(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getUsedMemory(sessionIdentifier);
    }

    public String getVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getVersion(sessionIdentifier);
    }

    public String[] getSqlWarnings(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.system.getSqlWarnings(sessionIdentifier);
    }

    public String getLoginBanner() throws GeneralizedException {
        String loginBanner = this.system.getLoginBanner();
        if (loginBanner == null) {
            return "";
        }
        return loginBanner;
    }

    public Hashtable<String, Object> getManagerStatus(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        Application.ApplicationStatusDescriptor statusDesc = this.system.getManagerStatus(sessionIdentifier);
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("LongDescription", statusDesc.getLongDescription());
        hash.put("ShortDescription", statusDesc.getShortDescription());
        hash.put("DatabaseConnectionCount", statusDesc.getStatusEntry("Database Connections").getStatus());
        hash.put("MemoryStatus", statusDesc.getStatusEntry("Memory Utilization").getStatus());
        hash.put("ScannerStatus", statusDesc.getStatusEntry("Scanner Status").getStatus());
        hash.put("StatusLevel", statusDesc.getOverallStatus());
        hash.put("ThreadStatus", statusDesc.getStatusEntry("Thread Count").getStatus());
        return hash;
    }

    public Vector<Hashtable<String, Object>> getOperationalMetrics(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        ApplicationStateMonitor.ApplicationStateDataPoint[] dataPoints = this.system.getOperationalMetrics(sessionIdentifier);
        Vector<Hashtable<String, Object>> dataPointsVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < dataPoints.length) {
            dataPointsVector.add(dataPoints[c].toHashtable());
            ++c;
        }
        return dataPointsVector;
    }
}

