/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.io.Serializable;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public abstract class GenericServlet
implements Servlet,
ServletConfig,
Serializable {
    private transient ServletConfig _config;

    public void init(ServletConfig config) throws ServletException {
        this._config = config;
        this.log("init");
        this.init();
    }

    public void init() throws ServletException {
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getServletName() {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getServletName() : this.getClass().getName();
    }

    public String getInitParameter(String name) {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getInitParameter(name) : null;
    }

    public Enumeration getInitParameterNames() {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getInitParameterNames() : null;
    }

    public ServletContext getServletContext() {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getServletContext() : null;
    }

    public String getServletInfo() {
        return "";
    }

    public void log(String message) {
        ServletContext app = this.getServletContext();
        if (app != null) {
            String name = this.getServletName();
            app.log(this.getServletName() + ": " + message);
        }
    }

    public void log(String message, Throwable cause) {
        ServletContext app = this.getServletContext();
        if (app != null) {
            app.log(this.getClass().getName() + ": " + message, cause);
        }
    }

    public void destroy() {
        this.log("destroy");
    }
}

