/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Evaluator;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    private final Tag tag;
    private Set<String> classNames;

    public Element(Tag tag, String baseUri, Attributes attributes) {
        super(baseUri, attributes);
        Validate.notNull(tag);
        this.tag = tag;
    }

    public Element(Tag tag, String baseUri) {
        this(tag, baseUri, new Attributes());
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        String id = this.attr("id");
        return id == null ? "" : id;
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    public Map<String, String> dataset() {
        return this.attributes.dataset();
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements parents = new Elements();
        Element.accumulateParents(this, parents);
        return parents;
    }

    private static void accumulateParents(Element el, Elements parents) {
        Element parent = el.parent();
        if (parent != null && !parent.tagName().equals("#root")) {
            parents.add(parent);
            Element.accumulateParents(parent, parents);
        }
    }

    public Element child(int index) {
        return this.children().get(index);
    }

    public Elements children() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node node : this.childNodes) {
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        return new Elements((List<Element>)elements);
    }

    public Elements select(String query) {
        return Selector.select(query, this);
    }

    public Element appendChild(Node child) {
        Validate.notNull(child);
        this.addChildren(child);
        return this;
    }

    public Element prependChild(Node child) {
        Validate.notNull(child);
        this.addChildren(0, child);
        return this;
    }

    public Element appendElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.appendChild(child);
        return child;
    }

    public Element prependElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.prependChild(child);
        return child;
    }

    public Element appendText(String text) {
        TextNode node = new TextNode(text, this.baseUri());
        this.appendChild(node);
        return this;
    }

    public Element prependText(String text) {
        TextNode node = new TextNode(text, this.baseUri());
        this.prependChild(node);
        return this;
    }

    public Element append(String html) {
        Validate.notNull(html);
        Element fragment = Parser.parseBodyFragmentRelaxed(html, this.baseUri()).body();
        this.addChildren(fragment.childNodesAsArray());
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull(html);
        Element fragment = Parser.parseBodyFragmentRelaxed(html, this.baseUri()).body();
        this.addChildren(0, fragment.childNodesAsArray());
        return this;
    }

    public Element before(String html) {
        this.addSiblingHtml(this.siblingIndex(), html);
        return this;
    }

    public Element after(String html) {
        this.addSiblingHtml(this.siblingIndex() + 1, html);
        return this;
    }

    private void addSiblingHtml(int index, String html) {
        Validate.notNull(html);
        Validate.notNull(this.parentNode);
        Element fragment = Parser.parseBodyFragmentRelaxed(html, this.baseUri()).body();
        this.parentNode.addChildren(index, fragment.childNodesAsArray());
    }

    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    public Element wrap(String html) {
        Validate.notEmpty(html);
        Element wrapBody = Parser.parseBodyFragmentRelaxed(html, this.baseUri).body();
        Elements wrapChildren = wrapBody.children();
        Element wrap = wrapChildren.first();
        if (wrap == null) {
            return null;
        }
        Element deepest = this.getDeepChild(wrap);
        this.parentNode.replaceChild(this, wrap);
        deepest.addChildren(this);
        if (wrapChildren.size() > 1) {
            for (int i = 1; i < wrapChildren.size(); ++i) {
                Element remainder = wrapChildren.get(i);
                remainder.parentNode.removeChild(remainder);
                wrap.appendChild(remainder);
            }
        }
        return this;
    }

    private Element getDeepChild(Element el) {
        Elements children = el.children();
        if (children.size() > 0) {
            return this.getDeepChild((Element)children.get(0));
        }
        return el;
    }

    public Elements siblingElements() {
        return this.parent().children();
    }

    public Element nextElementSibling() {
        Elements siblings = this.parent().children();
        Integer index = Element.indexInList(this, siblings);
        Validate.notNull(index);
        if (siblings.size() > index + 1) {
            return (Element)siblings.get(index + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        Elements siblings = this.parent().children();
        Integer index = Element.indexInList(this, siblings);
        Validate.notNull(index);
        if (index > 0) {
            return (Element)siblings.get(index - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        Elements siblings = this.parent().children();
        return siblings.size() > 1 ? (Element)siblings.get(0) : null;
    }

    public Integer elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().children());
    }

    public Element lastElementSibling() {
        Elements siblings = this.parent().children();
        return siblings.size() > 1 ? (Element)siblings.get(siblings.size() - 1) : null;
    }

    private static <E extends Element> Integer indexInList(Element search, List<E> elements) {
        Validate.notNull(search);
        Validate.notNull(elements);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            if (!element.equals(search)) continue;
            return i;
        }
        return null;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty(tagName);
        tagName = tagName.toLowerCase().trim();
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    public Element getElementById(String id) {
        Validate.notEmpty(id);
        Elements elements = Collector.collect(new Evaluator.Id(id), this);
        if (elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty(key);
        key = key.trim().toLowerCase();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeStarting(String keyPrefix) {
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim().toLowerCase();
        return Collector.collect(new Evaluator.AttributeStarting(keyPrefix), this);
    }

    public Elements getElementsByAttributeValue(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsByAttributeValueMatching(key, pattern);
    }

    public Elements getElementsByIndexLessThan(int index) {
        return Collector.collect(new Evaluator.IndexLessThan(index), this);
    }

    public Elements getElementsByIndexGreaterThan(int index) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index), this);
    }

    public Elements getElementsByIndexEquals(int index) {
        return Collector.collect(new Evaluator.IndexEquals(index), this);
    }

    public Elements getElementsContainingText(String searchText) {
        return Collector.collect(new Evaluator.ContainsText(searchText), this);
    }

    public Elements getElementsContainingOwnText(String searchText) {
        return Collector.collect(new Evaluator.ContainsOwnText(searchText), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        this.text(sb);
        return sb.toString().trim();
    }

    private void text(StringBuilder accum) {
        for (Node child : this.childNodes) {
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                this.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            if (accum.length() > 0 && element.isBlock() && !TextNode.lastCharIsWhitespace(accum)) {
                accum.append(" ");
            }
            element.text(accum);
        }
    }

    public String ownText() {
        StringBuilder sb = new StringBuilder();
        this.ownText(sb);
        return sb.toString().trim();
    }

    private void ownText(StringBuilder accum) {
        for (Node child : this.childNodes) {
            if (!(child instanceof TextNode)) continue;
            TextNode textNode = (TextNode)child;
            this.appendNormalisedText(accum, textNode);
        }
    }

    private void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        String text = textNode.getWholeText();
        if (!this.preserveWhitespace()) {
            text = TextNode.normaliseWhitespace(text);
            if (TextNode.lastCharIsWhitespace(accum)) {
                text = TextNode.stripLeadingWhitespace(text);
            }
        }
        accum.append(text);
    }

    boolean preserveWhitespace() {
        return this.tag.preserveWhitespace() || this.parent() != null && this.parent().preserveWhitespace();
    }

    public Element text(String text) {
        Validate.notNull(text);
        this.empty();
        TextNode textNode = new TextNode(text, this.baseUri);
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        for (Node child : this.childNodes) {
            Element el;
            TextNode textNode;
            if (!(child instanceof TextNode ? !(textNode = (TextNode)child).isBlank() : child instanceof Element && (el = (Element)child).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder sb = new StringBuilder();
        for (Node childNode : this.childNodes) {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
                continue;
            }
            if (!(childNode instanceof Element)) continue;
            Element element = (Element)childNode;
            String elementData = element.data();
            sb.append(elementData);
        }
        return sb.toString();
    }

    public String className() {
        return this.attributes.hasKey("class") ? this.attributes.get("class") : "";
    }

    public Set<String> classNames() {
        if (this.classNames == null) {
            String[] names = this.className().split("\\s+");
            this.classNames = new LinkedHashSet<String>(Arrays.asList(names));
        }
        return this.classNames;
    }

    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        this.attributes.put("class", StringUtil.join(classNames, " "));
        return this;
    }

    public boolean hasClass(String className) {
        return this.classNames().contains(className);
    }

    public Element addClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.add(className);
        this.classNames(classes);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.remove(className);
        this.classNames(classes);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            classes.add(className);
        }
        this.classNames(classes);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value) {
        if (this.tagName().equals("textarea")) {
            this.text(value);
        } else {
            this.attr("value", value);
        }
        return this;
    }

    @Override
    void outerHtmlHead(StringBuilder accum, int depth, Document.OutputSettings out) {
        if (out.prettyPrint() && (this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock())) {
            this.indent(accum, depth, out);
        }
        accum.append("<").append(this.tagName());
        this.attributes.html(accum, out);
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            accum.append(" />");
        } else {
            accum.append(">");
        }
    }

    @Override
    void outerHtmlTail(StringBuilder accum, int depth, Document.OutputSettings out) {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (out.prettyPrint() && !this.childNodes.isEmpty() && this.tag.formatAsBlock()) {
                this.indent(accum, depth, out);
            }
            accum.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        this.html(accum);
        return accum.toString().trim();
    }

    private void html(StringBuilder accum) {
        for (Node node : this.childNodes) {
            node.outerHtml(accum);
        }
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Element element = (Element)o;
        return !(this.tag != null ? !this.tag.equals(element.tag) : element.tag != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }

    @Override
    public Element clone() {
        Element clone = (Element)super.clone();
        clone.classNames();
        return clone;
    }
}

