/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.SortedSet;
import java.util.TreeSet;
import sun.org.mozilla.javascript.internal.Node;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Comment;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;

public class AstRoot
extends ScriptNode {
    private SortedSet<Comment> comments;
    private boolean inStrictMode;

    public AstRoot() {
        this.type = 136;
    }

    public AstRoot(int n) {
        super(n);
        this.type = 136;
    }

    public SortedSet<Comment> getComments() {
        return this.comments;
    }

    public void setComments(SortedSet<Comment> sortedSet) {
        if (sortedSet == null) {
            this.comments = null;
        } else {
            if (this.comments != null) {
                this.comments.clear();
            }
            for (Comment comment : sortedSet) {
                this.addComment(comment);
            }
        }
    }

    public void addComment(Comment comment) {
        this.assertNotNull(comment);
        if (this.comments == null) {
            this.comments = new TreeSet<AstNode>(new AstNode.PositionComparator());
        }
        this.comments.add(comment);
        comment.setParent(this);
    }

    public void setInStrictMode(boolean bl) {
        this.inStrictMode = bl;
    }

    public boolean isInStrictMode() {
        return this.inStrictMode;
    }

    public void visitComments(NodeVisitor nodeVisitor) {
        if (this.comments != null) {
            for (Comment comment : this.comments) {
                nodeVisitor.visit(comment);
            }
        }
    }

    public void visitAll(NodeVisitor nodeVisitor) {
        this.visit(nodeVisitor);
        this.visitComments(nodeVisitor);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : this) {
            stringBuilder.append(((AstNode)node).toSource(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public String debugPrint() {
        AstNode.DebugPrintVisitor debugPrintVisitor = new AstNode.DebugPrintVisitor(new StringBuilder(1000));
        this.visitAll(debugPrintVisitor);
        return debugPrintVisitor.toString();
    }

    public void checkParentLinks() {
        this.visit(new NodeVisitor(){

            @Override
            public boolean visit(AstNode astNode) {
                int n = astNode.getType();
                if (n == 136) {
                    return true;
                }
                if (astNode.getParent() == null) {
                    throw new IllegalStateException("No parent for node: " + astNode + "\n" + astNode.toSource(0));
                }
                return true;
            }
        });
    }
}

