# 
# TAOF, the general purpose TCP fuzzer.
# Copyright (C) 2007 Rodrigo Marcos
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# 

#Python libraries
import os# for folder creation

#import xml.dom.minidom # for xml input/output
#import time #for folder creation and sleep


#Taof libraries
from xmlutil import *
from dataretrieval import *
from logger import *
from xmlsettings import *
from engine import *

#Third party libraries
#import gtk


taof_version = 0.3 # for versioning
context = {}

context["RECV_BUFFER_SIZE"] = 8192
context["REQUEST_COUNTER"] = 0
context["debug"] = 1
context["stopfuzzing"] = 0
context["proto"] = "tcp"
context["os"] = os.name
context["currentsignature"] = 0

if context["os"]=='nt':
	context["TAOF_PATH"] = os.getcwd() + '\\'
	context["TAOF_HELP_PATH"] = context["TAOF_PATH"] + 'help\\index.html'
else:
	context["TAOF_PATH"] = os.getcwd() + '/'
	context["TAOF_HELP_PATH"] = context["TAOF_PATH"] + 'help/index.html'

taof_settings = xmlsettings()
taof_settings.get_settings()

