#!/usr/bin/python
'''
//=============================================================================
//
//  File : scannerguy.py
//  Creation date : Wed Dec 05 14:30:48 CEST 2012
//  Working on this file:   asterix (Cristian Steri)
//                          Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''
import subprocess

def get_interface_info(interface_name):
    cmd_interface = "netsh wlan show interfaces"
    output_interface = subprocess.Popen(cmd_interface, stdout=subprocess.PIPE, shell=True)
    output_interface = output_interface.stdout.read()
    guidlist = reversed(output_interface.splitlines())
    n_info = 0
    netlist = {}
    guid = ""
    name = ""
    description = ""
                             
    for line in guidlist:
        if n_info == 2:
            n_info = 0
            name = line.split(":")[1].strip()
        if n_info == 1:
            n_info = n_info+1
            description = line.split(":")[1].strip()
        if "GUID" in line:
            if n_info == 0:
                guid = line.split(":")[1].strip()
                n_info = n_info+1

        if guid and name and description:
            netlist[name] = [guid, name, description]
            guid = ""
            name = ""
            description = ""
    return netlist[interface_name][0]
    
def wlan_scanner():
    cmd = "netsh wlan show networks mode=bssid"
    out = subprocess.Popen(cmd, stdout=subprocess.PIPE, shell=True)
    lines = out.stdout
    line = lines.readline()
    interfaces = {}
    while True:
        if not line:
            break
        if line.startswith('SSID'):
            ssiddata = {}
            ssiddata['bssid'] = {}
            interface[line.split(':', 1)[1].strip()] = ssiddata
            line = lines.readline()
            while line and not line.lstrip().startswith('BSSID'):
                if ":" in line:
                    key, value = line.split(':', 1)
                    ssiddata[key.strip()] = value.strip()
                line = lines.readline()
            continue
        elif line.lstrip().startswith('BSSID'):
            bssiddata = {}
            ssiddata['bssid'][line.split(':', 1)[1].strip()] = bssiddata
            line = lines.readline()
            while line.strip() and not line.lstrip().startswith('BSSID'):
                key, value = line.split(':', 1)
                bssiddata[key.strip()] = value.strip()
                line = lines.readline()
            continue
        elif line.strip() and ':' in line:
            interface = {}
            interfaces[line.split(':', 1)[1].strip()] = interface
        line = lines.readline()
        if not line:
            break
    return interfaces

def get_interfaces_list():
    net_info = wlan_scanner()
    interface_list = []
    for interface in net_info:
        interface_list.append(interface)
    return interface_list
