testcases_class_independent = [
["Device_bLength_null","dev_bLength",0],
["Device_bLength_lower","dev_bLength",1],
["Device_bLength_higher","dev_bLength",20],
["Device_bLength_max","dev_bLength",0xff],
["Device_bDescriptorType_null","dev_bDescriptorType",0],
["Device_bDescriptorType_invalid","dev_bDescriptorType",0xff],
["Device_bMaxPacketSize0_null","dev_bMaxPacketSize0",0],
["Device_bMaxPacketSize0_max","dev_bMaxPacketSize0",0xff],

["String_Manufacturer_overflow","string_Manufacturer","A" * 126],
["String_Product_overflow","string_Product","A" * 126],
["String_Serial_overflow","string_Serial","A" * 126],
["String_Manufacturer_formatstring","string_Manufacturer","%x%n%n"],
["String_Product_formatstring","string_Product","%x%n%n"],
["String_Serial_formatstring","string_Serial","%x%n%n"],

["Configuration_bLength_null","conf_bLength",0],
["Configuration_bLength_lower","conf_bLength",1],
["Configuration_bLength_higher","conf_bLength",10],
["Configuration_bLength_max","conf_bLength",0xff],
["Configuration_bDescriptorType_null","conf_bDescriptorType",0],
["Configuration_bDescriptorType_invalid","conf_bDescriptorType",0xff],
["Configuration_wTotalLength_null","conf_wTotalLength",0],
["Configuration_wTotalLength_lower","conf_wTotalLength",1],
["Configuration_wTotalLength_higher","conf_wTotalLength",0xfff0],
["Configuration_wTotalLength_max","conf_wTotalLength",0xffff],
["Configuration_bNumInterfaces_null","conf_bNumInterfaces",0],
["Configuration_bNumInterfaces_higher","conf_bNumInterfaces",0xf0],
["Configuration_bNumInterfaces_max","conf_bNumInterfaces",0xff],

["Interface_bLength_null","int_bLength",0],
["Interface_bLength_lower","int_bLength",1],
["Interface_bLength_higher","int_bLength",0xf0],
["Interface_bLength_max","int_bLength",0xff],
["Interface_bDescriptorType_null","int_bDescriptorType",0],
["Interface_bDescriptorType_invalid","int_bDescriptorType",0xff],
["Interface_bNumEndpoints_null","int_bNumEndpoints",0],
["Interface_bNumEndpoints_lower","int_bNumEndpoints",1],
["Interface_bNumEndpoints_higher","int_bNumEndpoints",0xf0],
["Interface_bNumEndpoints_max","int_bNumEndpoints",0xff],

["Endpoint_bLength_null","end_bLength",0],
["Endpoint_bLength_lower","end_bLength",1],
["Endpoint_bLength_higher","end_bLength",0xf0],
["Endpoint_bLength_max","end_bLength",0xff],
["Endpoint_bDescriptorType_null","end_bDescriptorType",0],
["Endpoint_bDescriptorType_invalid","end_bDescriptorType",0xff],
["Endpoint_bEndpointAddress_null","end_bEndpointAddress",0],
["Endpoint_bEndpointAddress_max","end_bEndpointAddress",0xff],
["Endpoint_wMaxPacketSize_null","end_wMaxPacketSize",0],
["Endpoint_wMaxPacketSize_max","end_wMaxPacketSize",0xffff],
]

# PIMA 15740
testcases_image_class = [
["DeviceInfo_ContainerLength_null","DeviceInfo_ContainerLength",b'\x00\x00\x00\x00'],
["DeviceInfo_ContainerLength_lower","DeviceInfo_ContainerLength",b'\x00\x00\x00\x01'],
["DeviceInfo_ContainerLength_higher","DeviceInfo_ContainerLength",b'\x00\x00\xff\xff'],
["DeviceInfo_ContainerLength_max","DeviceInfo_ContainerLength",b'\xff\xff\xff\xff'],
["DeviceInfo_ContainerType_null","DeviceInfo_ContainerType",b'\x00\x00'],
["DeviceInfo_ContainerType_max","DeviceInfo_ContainerType",b'\xff\xff'],
["DeviceInfo_OperationCode_null","DeviceInfo_OperationCode",b'\x00\x00'],
["DeviceInfo_OperationCode_max","DeviceInfo_OperationCode",b'\xff\xff'],
["DeviceInfo_TransactionID_null","DeviceInfo_TransactionID",b'\x00\x00\x00\x00'],
["DeviceInfo_TransactionID_max","DeviceInfo_TransactionID",b'\xff\xff\xff\xff'],
["DeviceInfo_StandardVersion_null","DeviceInfo_StandardVersion",b'\x00\x00'],
["DeviceInfo_StandardVersion_max","DeviceInfo_StandardVersion",b'\xff\xff'],
["DeviceInfo_VendorExtensionID_null","DeviceInfo_VendorExtensionID",b'\x00\x00\x00\x00'],
["DeviceInfo_VendorExtensionID_null","DeviceInfo_VendorExtensionID",b'\xff\xff\xff\xff'],
["DeviceInfo_VendorExtensionVersion_null","DeviceInfo_VendorExtensionVersion",b'\x00\x00'],
["DeviceInfo_VendorExtensionVersion_null","DeviceInfo_VendorExtensionVersion",b'\xff\xff'],
["DeviceInfo_VendorExtensionDesc_max","DeviceInfo_VendorExtensionDesc",b'\xff'],
["DeviceInfo_VendorExtensionDesc_overflow1","DeviceInfo_VendorExtensionDesc",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_VendorExtensionDesc_overflow2","DeviceInfo_VendorExtensionDesc",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_VendorExtensionDesc_overflow3","DeviceInfo_VendorExtensionDesc",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_VendorExtensionDesc_overflow4","DeviceInfo_VendorExtensionDesc",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_VendorExtensionDesc_formatstring","DeviceInfo_VendorExtensionDesc",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["DeviceInfo_FunctionalMode_max","DeviceInfo_FunctionalMode",b'\xff\xff'],
["DeviceInfo_OperationsSupportedArraySize_null","DeviceInfo_OperationsSupportedArraySize",b'\x00\x00\x00\x00'],
["DeviceInfo_OperationsSupportedArraySize_lower","DeviceInfo_OperationsSupportedArraySize",b'\x00\x00\x00\x01'],
["DeviceInfo_OperationsSupportedArraySize_higher","DeviceInfo_OperationsSupportedArraySize",b'\x00\x00\xff\xff'],
["DeviceInfo_OperationsSupportedArraySize_max","DeviceInfo_OperationsSupportedArraySize",b'\xff\xff\xff\xff'],
["DeviceInfo_OperationSupported_null","DeviceInfo_OperationSupported",b'\x00\x00'],
["DeviceInfo_OperationSupported_max","DeviceInfo_OperationSupported",b'\xff\xff'],
["DeviceInfo_EventsSupportedArraySize_null","DeviceInfo_EventsSupportedArraySize",b'\x00\x00\x00\x00'],
["DeviceInfo_EventsSupportedArraySize_lower","DeviceInfo_EventsSupportedArraySize",b'\x00\x00\x00\x01'],
["DeviceInfo_EventsSupportedArraySize_higher","DeviceInfo_EventsSupportedArraySize",b'\x00\x00\xff\xff'],
["DeviceInfo_EventsSupportedArraySize_max","DeviceInfo_EventsSupportedArraySize",b'\xff\xff\xff\xff'],
["DeviceInfo_EventSupported_null","DeviceInfo_EventSupported",b'\x00\x00'],
["DeviceInfo_EventSupported_max","DeviceInfo_EventSupported",b'\xff\xff'],
["DeviceInfo_DevicePropertiesSupportedArraySize_null","DeviceInfo_DevicePropertiesSupportedArraySize",b'\x00\x00\x00\x00'],
["DeviceInfo_DevicePropertiesSupportedArraySize_lower","DeviceInfo_DevicePropertiesSupportedArraySize",b'\x00\x00\x00\x01'],
["DeviceInfo_DevicePropertiesSupportedArraySize_higher","DeviceInfo_DevicePropertiesSupportedArraySize",b'\x00\x00\xff\xff'],
["DeviceInfo_DevicePropertiesSupportedArraySize_max","DeviceInfo_DevicePropertiesSupportedArraySize",b'\xff\xff\xff\xff'],
["DeviceInfo_DevicePropertySupported_null","DeviceInfo_DevicePropertySupported",b'\x00\x00'],
["DeviceInfo_DevicePropertySupported_max","DeviceInfo_DevicePropertySupported",b'\xff\xff'],
["DeviceInfo_CaptureFormatsSupportedArraySize_null","DeviceInfo_CaptureFormatsSupportedArraySize",b'\x00\x00\x00\x00'],
["DeviceInfo_CaptureFormatsSupportedArraySize_lower","DeviceInfo_CaptureFormatsSupportedArraySize",b'\x00\x00\x00\x01'],
["DeviceInfo_CaptureFormatsSupportedArraySize_higher","DeviceInfo_CaptureFormatsSupportedArraySize",b'\x00\x00\xff\xff'],
["DeviceInfo_CaptureFormatsSupportedArraySize_max","DeviceInfo_CaptureFormatsSupportedArraySize",b'\xff\xff\xff\xff'],
["DeviceInfo_ImageFormatsSupportedArraySize_null","DeviceInfo_ImageFormatsSupportedArraySize",b'\x00\x00\x00\x00'],
["DeviceInfo_ImageFormatsSupportedArraySize_lower","DeviceInfo_ImageFormatsSupportedArraySize",b'\x00\x00\x00\x01'],
["DeviceInfo_ImageFormatsSupportedArraySize_higher","DeviceInfo_ImageFormatsSupportedArraySize",b'\x00\x00\xff\xff'],
["DeviceInfo_ImageFormatsSupportedArraySize_max","DeviceInfo_ImageFormatsSupportedArraySize",b'\xff\xff\xff\xff'],
["DeviceInfo_ImageFormatSupported_null","DeviceInfo_ImageFormatSupported",b'\x00\x00'],
["DeviceInfo_ImageFormatSupported_max","DeviceInfo_ImageFormatSupported",b'\xff\xff'],
["DeviceInfo_Manufacturer_max","DeviceInfo_Manufacturer",b'\xff'],
["DeviceInfo_Manufacturer_overflow1","DeviceInfo_Manufacturer",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Manufacturer_overflow2","DeviceInfo_Manufacturer",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Manufacturer_overflow3","DeviceInfo_Manufacturer",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Manufacturer_overflow4","DeviceInfo_Manufacturer",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Manufacturer_formatstring","DeviceInfo_Manufacturer",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["DeviceInfo_Model_max","DeviceInfo_Model",b'\xff'],
["DeviceInfo_Model_overflow1","DeviceInfo_Model",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Model_overflow2","DeviceInfo_Model",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Model_overflow3","DeviceInfo_Model",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Model_overflow4","DeviceInfo_Model",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_Model_formatstring","DeviceInfo_Model",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["DeviceInfo_DeviceVersion_max","DeviceInfo_DeviceVersion",b'\xff'],
["DeviceInfo_DeviceVersion_overflow1","DeviceInfo_DeviceVersion",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_DeviceVersion_overflow2","DeviceInfo_DeviceVersion",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_DeviceVersion_overflow3","DeviceInfo_DeviceVersion",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_DeviceVersion_overflow4","DeviceInfo_DeviceVersion",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_DeviceVersion_formatstring","DeviceInfo_DeviceVersion",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["DeviceInfo_SerialNumber_max","DeviceInfo_SerialNumber",b'\xff'],
["DeviceInfo_SerialNumber_overflow1","DeviceInfo_SerialNumber",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_SerialNumber_overflow2","DeviceInfo_SerialNumber",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_SerialNumber_overflow3","DeviceInfo_SerialNumber",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_SerialNumber_overflow4","DeviceInfo_SerialNumber",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["DeviceInfo_SerialNumber_formatstring","DeviceInfo_SerialNumber",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],

["StorageIDArray_ContainerLength_null","StorageIDArray_ContainerLength",b'\x00\x00\x00\x00'],
["StorageIDArray_ContainerLength_lower","StorageIDArray_ContainerLength",b'\x00\x00\x00\x01'],
["StorageIDArray_ContainerLength_higher","StorageIDArray_ContainerLength",b'\x00\x00\xff\xff'],
["StorageIDArray_ContainerLength_max","StorageIDArray_ContainerLength",b'\xff\xff\xff\xff'],
["StorageIDArray_ContainerType_null","StorageIDArray_ContainerType",b'\x00\x00'],
["StorageIDArray_ContainerType_max","StorageIDArray_ContainerType",b'\xff\xff'],
["StorageIDArray_OperationCode_null","StorageIDArray_OperationCode",b'\x00\x00'],
["StorageIDArray_OperationCode_max","StorageIDArray_OperationCode",b'\xff\xff'],
["StorageIDArray_TransactionID_null","StorageIDArray_TransactionID",b'\x00\x00\x00\x00'],
["StorageIDArray_TransactionID_max","StorageIDArray_TransactionID",b'\xff\xff\xff\xff'],
["StorageIDArray_StorageIDsArraySize_null","StorageIDArray_StorageIDsArraySize",b'\x00\x00\x00\x00'],
["StorageIDArray_StorageIDsArraySize_lower","StorageIDArray_StorageIDsArraySize",b'\x00\x00\x00\x01'],
["StorageIDArray_StorageIDsArraySize_higher","StorageIDArray_StorageIDsArraySize",b'\x00\x00\xff\xff'],
["StorageIDArray_StorageIDsArraySize_max","StorageIDArray_StorageIDsArraySize",b'\xff\xff\xff\xff'],
["StorageIDArray_StorageID_null","StorageIDArray_StorageID",b'\x00\x00'],
["StorageIDArray_StorageID_max","StorageIDArray_StorageID",b'\xff\xff'],

["StorageInfo_ContainerLength_null","StorageInfo_ContainerLength",b'\x00\x00\x00\x00'],
["StorageInfo_ContainerLength_lower","StorageInfo_ContainerLength",b'\x00\x00\x00\x01'],
["StorageInfo_ContainerLength_higher","StorageInfo_ContainerLength",b'\x00\x00\xff\xff'],
["StorageInfo_ContainerLength_max","StorageInfo_ContainerLength",b'\xff\xff\xff\xff'],
["StorageInfo_ContainerType_null","StorageInfo_ContainerType",b'\x00\x00'],
["StorageInfo_ContainerType_max","StorageInfo_ContainerType",b'\xff\xff'],
["StorageInfo_OperationCode_null","StorageInfo_OperationCode",b'\x00\x00'],
["StorageInfo_OperationCode_max","StorageInfo_OperationCode",b'\xff\xff'],
["StorageInfo_TransactionID_null","StorageInfo_TransactionID",b'\x00\x00\x00\x00'],
["StorageInfo_TransactionID_max","StorageInfo_TransactionID",b'\xff\xff\xff\xff'],
["StorageInfo_StorageType_null","StorageInfo_StorageType",b'\x00\x00'],
["StorageInfo_StorageType_max","StorageInfo_StorageType",b'\xff\xff'],
["StorageInfo_FilesystemType_null","StorageInfo_FilesystemType",b'\x00\x00'],
["StorageInfo_FilesystemType_max","StorageInfo_FilesystemType",b'\xff\xff'],
["StorageInfo_AccessCapability_null","StorageInfo_AccessCapability",b'\x00\x00'],
["StorageInfo_AccessCapability_max","StorageInfo_AccessCapability",b'\xff\xff'],
["StorageInfo_MaxCapacity_null","StorageInfo_MaxCapacity",b'\x00\x00\x00\x00\x00\x00\x00\x00'],
["StorageInfo_MaxCapacity_max","StorageInfo_MaxCapacity",b'\xff\xff\xff\xff\xff\xff\xff\xff'],
["StorageInfo_FreeSpaceInBytes_null","StorageInfo_FreeSpaceInBytes",b'\x00\x00\x00\x00\x00\x00\x00\x00'],
["StorageInfo_FreeSpaceInBytes_max","StorageInfo_FreeSpaceInBytes",b'\xff\xff\xff\xff\xff\xff\xff\xff'],
["StorageInfo_FreeSpaceInImages_null","StorageInfo_FreeSpaceInImages",b'\x00\x00\x00\x00'],
["StorageInfo_FreeSpaceInImages_max","StorageInfo_FreeSpaceInImages",b'\xff\xff\xff\xff'],
["StorageInfo_StorageDescription_max","StorageInfo_StorageDescription",b'\xff'],
["StorageInfo_StorageDescription_overflow1","StorageInfo_StorageDescription",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_StorageDescription_overflow2","StorageInfo_StorageDescription",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_StorageDescription_overflow3","StorageInfo_StorageDescription",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_StorageDescription_overflow4","StorageInfo_StorageDescription",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_StorageDescription_formatstring","StorageInfo_StorageDescription",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["StorageInfo_VolumeLabel_max","StorageInfo_VolumeLabel",b'\xff'],
["StorageInfo_VolumeLabel_overflow1","StorageInfo_VolumeLabel",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_VolumeLabel_overflow2","StorageInfo_VolumeLabel",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_VolumeLabel_overflow3","StorageInfo_VolumeLabel",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_VolumeLabel_overflow4","StorageInfo_VolumeLabel",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["StorageInfo_VolumeLabel_formatstring","StorageInfo_VolumeLabel",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],

["ObjectHandles_ContainerLength_null","ObjectHandles_ContainerLength",b'\x00\x00\x00\x00'],
["ObjectHandles_ContainerLength_lower","ObjectHandles_ContainerLength",b'\x00\x00\x00\x01'],
["ObjectHandles_ContainerLength_higher","ObjectHandles_ContainerLength",b'\x00\x00\xff\xff'],
["ObjectHandles_ContainerLength_max","ObjectHandles_ContainerLength",b'\xff\xff\xff\xff'],
["ObjectHandles_ContainerType_null","ObjectHandles_ContainerType",b'\x00\x00'],
["ObjectHandles_ContainerType_max","ObjectHandles_ContainerType",b'\xff\xff'],
["ObjectHandles_OperationCode_null","ObjectHandles_OperationCode",b'\x00\x00'],
["ObjectHandles_OperationCode_max","ObjectHandles_OperationCode",b'\xff\xff'],
["ObjectHandles_TransactionID_null","ObjectHandles_TransactionID",b'\x00\x00\x00\x00'],
["ObjectHandles_TransactionID_max","ObjectHandles_TransactionID",b'\xff\xff\xff\xff'],
["ObjectHandles_ObjectHandleArraySize_null","ObjectHandles_ObjectHandleArraySize",b'\x00\x00\x00\x00'],
["ObjectHandles_ObjectHandleArraySize_lower","ObjectHandles_ObjectHandleArraySize",b'\x00\x00\x00\x01'],
["ObjectHandles_ObjectHandleArraySize_higher","ObjectHandles_ObjectHandleArraySize",b'\x00\x00\xff\xff'],
["ObjectHandles_ObjectHandleArraySize_max","ObjectHandles_ObjectHandleArraySize",b'\xff\xff\xff\xff'],
["ObjectHandles_ObjectHandle_null","ObjectHandles_ObjectHandle",b'\x00\x00'],
["ObjectHandles_ObjectHandle_max","ObjectHandles_ObjectHandle",b'\xff\xff'],

["ObjectInfo_ContainerLength_null","ObjectInfo_ContainerLength",b'\x00\x00\x00\x00'],
["ObjectInfo_ContainerLength_lower","ObjectInfo_ContainerLength",b'\x00\x00\x00\x01'],
["ObjectInfo_ContainerLength_higher","ObjectInfo_ContainerLength",b'\x00\x00\xff\xff'],
["ObjectInfo_ContainerLength_max","ObjectInfo_ContainerLength",b'\xff\xff\xff\xff'],
["ObjectInfo_ContainerType_null","ObjectInfo_ContainerType",b'\x00\x00'],
["ObjectInfo_ContainerType_max","ObjectInfo_ContainerType",b'\xff\xff'],
["ObjectInfo_OperationCode_null","ObjectInfo_OperationCode",b'\x00\x00'],
["ObjectInfo_OperationCode_max","ObjectInfo_OperationCode",b'\xff\xff'],
["ObjectInfo_TransactionID_null","ObjectInfo_TransactionID",b'\x00\x00\x00\x00'],
["ObjectInfo_TransactionID_max","ObjectInfo_TransactionID",b'\xff\xff\xff\xff'],
["ObjectInfo_StorageID_null","ObjectInfo_StorageID",b'\x00\x00'],
["ObjectInfo_StorageID_max","ObjectInfo_StorageID",b'\xff\xff'],
["ObjectInfo_ObjectFormat_null","ObjectInfo_ObjectFormat",b'\x00\x00\x00\x00'],
["ObjectInfo_ObjectFormat_lower","ObjectInfo_ObjectFormat",b'\x00\x00\x00\x01'],
["ObjectInfo_ObjectFormat_higher","ObjectInfo_ObjectFormat",b'\x00\x00\xff\xff'],
["ObjectInfo_ObjectFormat_max","ObjectInfo_ObjectFormat",b'\xff\xff\xff\xff'],
["ObjectInfo_ProtectionStatus_null","ObjectInfo_ProtectionStatus",b'\x00\x00'],
["ObjectInfo_ProtectionStatus_max","ObjectInfo_ProtectionStatus",b'\xff\xff'],
["ObjectInfo_ObjectCompressedSize_null","ObjectInfo_ObjectCompressedSize",b'\x00\x00\x00\x00'],
["ObjectInfo_ObjectCompressedSize_lower","ObjectInfo_ObjectCompressedSize",b'\x00\x00\x00\x01'],
["ObjectInfo_ObjectCompressedSize_higher","ObjectInfo_ObjectCompressedSize",b'\x00\x00\xff\xff'],
["ObjectInfo_ObjectCompressedSize_max","ObjectInfo_ObjectCompressedSize",b'\xff\xff\xff\xff'],
["ObjectInfo_ThumbFormat_null","ObjectInfo_ThumbFormat",b'\x00\x00\x00\x00'],
["ObjectInfo_ThumbFormat_max","ObjectInfo_ThumbFormat",b'\xff\xff\xff\xff'],
["ObjectInfo_ThumbCompressedSize_null","ObjectInfo_ThumbCompressedSize",b'\x00\x00\x00\x00'],
["ObjectInfo_ThumbCompressedSize_lower","ObjectInfo_ThumbCompressedSize",b'\x00\x00\x00\x01'],
["ObjectInfo_ThumbCompressedSize_higher","ObjectInfo_ThumbCompressedSize",b'\x00\x00\xff\xff'],
["ObjectInfo_ThumbCompressedSize_max","ObjectInfo_ThumbCompressedSize",b'\xff\xff\xff\xff'],
["ObjectInfo_ThumbPixelWidth_null","ObjectInfo_ThumbPixelWidth",b'\x00\x00\x00\x00'],
["ObjectInfo_ThumbPixelWidth_lower","ObjectInfo_ThumbPixelWidth",b'\x00\x00\x00\x01'],
["ObjectInfo_ThumbPixelWidth_higher","ObjectInfo_ThumbPixelWidth",b'\x00\x00\xff\xff'],
["ObjectInfo_ThumbPixelWidth_max","ObjectInfo_ThumbPixelWidth",b'\xff\xff\xff\xff'],
["ObjectInfo_ThumbPixelHeight_null","ObjectInfo_ThumbPixelHeight",b'\x00\x00\x00\x00'],
["ObjectInfo_ThumbPixelHeight_lower","ObjectInfo_ThumbPixelHeight",b'\x00\x00\x00\x01'],
["ObjectInfo_ThumbPixelHeight_higher","ObjectInfo_ThumbPixelHeight",b'\x00\x00\xff\xff'],
["ObjectInfo_ThumbPixelHeight_max","ObjectInfo_ThumbPixelHeight",b'\xff\xff\xff\xff'],
["ObjectInfo_ImagePixelWidth_null","ObjectInfo_ImagePixelWidth",b'\x00\x00\x00\x00'],
["ObjectInfo_ImagePixelWidth_lower","ObjectInfo_ImagePixelWidth",b'\x00\x00\x00\x01'],
["ObjectInfo_ImagePixelWidth_higher","ObjectInfo_ImagePixelWidth",b'\x00\x00\xff\xff'],
["ObjectInfo_ImagePixelWidth_max","ObjectInfo_ImagePixelWidth",b'\xff\xff\xff\xff'],
["ObjectInfo_ImagePixelHeight_null","ObjectInfo_ImagePixelHeight",b'\x00\x00\x00\x00'],
["ObjectInfo_ImagePixelHeight_lower","ObjectInfo_ImagePixelHeight",b'\x00\x00\x00\x01'],
["ObjectInfo_ImagePixelHeight_higher","ObjectInfo_ImagePixelHeight",b'\x00\x00\xff\xff'],
["ObjectInfo_ImagePixelHeight_max","ObjectInfo_ImagePixelHeight",b'\xff\xff\xff\xff'],
["ObjectInfo_ImagePixelDepth_null","ObjectInfo_ImagePixelDepth",b'\x00\x00\x00\x00'],
["ObjectInfo_ImagePixelDepth_lower","ObjectInfo_ImagePixelDepth",b'\x00\x00\x00\x01'],
["ObjectInfo_ImagePixelDepth_higher","ObjectInfo_ImagePixelDepth",b'\x00\x00\xff\xff'],
["ObjectInfo_ImagePixelDepth_max","ObjectInfo_ImagePixelDepth",b'\xff\xff\xff\xff'],
["ObjectInfo_ParentObject_null","ObjectInfo_ParentObject",b'\x00\x00\x00\x00'],
["ObjectInfo_ParentObject_max","ObjectInfo_ParentObject",b'\xff\xff\xff\xff'],
["ObjectInfo_AssociationType_null","ObjectInfo_AssociationType",b'\x00\x00'],
["ObjectInfo_AssociationType_max","ObjectInfo_AssociationType",b'\xff\xff'],
["ObjectInfo_AssociationDesc_null","ObjectInfo_AssociationDesc",b'\x00\x00\x00\x00'],
["ObjectInfo_AssociationDesc_max","ObjectInfo_AssociationDesc",b'\xff\xff\xff\xff'],
["ObjectInfo_SequenceNumber_null","ObjectInfo_SequenceNumber",b'\x00\x00\x00\x00'],
["ObjectInfo_SequenceNumber_lower","ObjectInfo_SequenceNumber",b'\x00\x00\x00\x01'],
["ObjectInfo_SequenceNumber_higher","ObjectInfo_SequenceNumber",b'\x00\x00\xff\xff'],
["ObjectInfo_SequenceNumber_max","ObjectInfo_SequenceNumber",b'\xff\xff\xff\xff'],
["ObjectInfo_Filename_max","ObjectInfo_Filename",b'\xff'],
["ObjectInfo_Filename_overflow1","ObjectInfo_Filename",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Filename_overflow2","ObjectInfo_Filename",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Filename_overflow3","ObjectInfo_Filename",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Filename_overflow4","ObjectInfo_Filename",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Filename_formatstring","ObjectInfo_Filename",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["ObjectInfo_CaptureDate_max","ObjectInfo_CaptureDate",b'\xff'],
["ObjectInfo_CaptureDate_overflow1","ObjectInfo_CaptureDate",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_CaptureDate_overflow2","ObjectInfo_CaptureDate",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_CaptureDate_overflow3","ObjectInfo_CaptureDate",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_CaptureDate_overflow4","ObjectInfo_CaptureDate",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_CaptureDate_formatstring","ObjectInfo_CaptureDate",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["ObjectInfo_ModificationDate_max","ObjectInfo_ModificationDate",b'\xff'],
["ObjectInfo_ModificationDate_overflow1","ObjectInfo_ModificationDate",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_ModificationDate_overflow2","ObjectInfo_ModificationDate",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_ModificationDate_overflow3","ObjectInfo_ModificationDate",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_ModificationDate_overflow4","ObjectInfo_ModificationDate",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_ModificationDate_formatstring","ObjectInfo_ModificationDate",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
["ObjectInfo_Keywords_max","ObjectInfo_Keywords",b'\xff'],
["ObjectInfo_Keywords_overflow1","ObjectInfo_Keywords",b'\xfe' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Keywords_overflow2","ObjectInfo_Keywords",b'\x00' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Keywords_overflow3","ObjectInfo_Keywords",b'\x20' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Keywords_overflow4","ObjectInfo_Keywords",b'\xff' + b'\x61\x00' * 254 + b'\x00\x00'],
["ObjectInfo_Keywords_formatstring","ObjectInfo_Keywords",b'\x06' + b'\x25\x00\x78\x00\x25\x00\x6e\x00\x25\x00\x6e\x00' + b'\x00\x00'],
]

testcases_printer_class = [
["DeviceID_Key1_null","Device_ID_Key1",b'\x00'],
["DeviceID_Key1_overflow1","Device_ID_Key1",b'\x61' * 300],
["DeviceID_Key1_overflow2","Device_ID_Key1",b'\x61' * 1200],
["DeviceID_Key1_overflow3","Device_ID_Key1",b'\x61' * 2400],
["DeviceID_Key1_overflow4","Device_ID_Key1",b'\x61' * 5000],
["DeviceID_Key1_formatstring","Device_ID_Key1",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Key2_null","Device_ID_Key2",b'\x00'],
["DeviceID_Key2_overflow1","Device_ID_Key2",b'\x61' * 300],
["DeviceID_Key2_overflow2","Device_ID_Key2",b'\x61' * 1200],
["DeviceID_Key2_overflow3","Device_ID_Key2",b'\x61' * 2400],
["DeviceID_Key2_overflow4","Device_ID_Key2",b'\x61' * 5000],
["DeviceID_Key2_formatstring","Device_ID_Key2",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Key3_null","Device_ID_Key3",b'\x00'],
["DeviceID_Key3_overflow1","Device_ID_Key3",b'\x61' * 300],
["DeviceID_Key3_overflow2","Device_ID_Key3",b'\x61' * 1200],
["DeviceID_Key3_overflow3","Device_ID_Key3",b'\x61' * 2400],
["DeviceID_Key3_overflow4","Device_ID_Key3",b'\x61' * 5000],
["DeviceID_Key3_formatstring","Device_ID_Key3",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Key4_null","Device_ID_Key4",b'\x00'],
["DeviceID_Key4_overflow1","Device_ID_Key4",b'\x61' * 300],
["DeviceID_Key4_overflow2","Device_ID_Key4",b'\x61' * 1200],
["DeviceID_Key4_overflow3","Device_ID_Key4",b'\x61' * 2400],
["DeviceID_Key4_overflow4","Device_ID_Key4",b'\x61' * 5000],
["DeviceID_Key4_formatstring","Device_ID_Key4",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Key5_null","Device_ID_Key5",b'\x00'],
["DeviceID_Key5_overflow1","Device_ID_Key5",b'\x61' * 300],
["DeviceID_Key5_overflow2","Device_ID_Key5",b'\x61' * 1200],
["DeviceID_Key5_overflow3","Device_ID_Key5",b'\x61' * 2400],
["DeviceID_Key5_overflow4","Device_ID_Key5",b'\x61' * 5000],
["DeviceID_Key5_formatstring","Device_ID_Key5",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Key6_null","Device_ID_Key6",b'\x00'],
["DeviceID_Key6_overflow1","Device_ID_Key6",b'\x61' * 300],
["DeviceID_Key6_overflow2","Device_ID_Key6",b'\x61' * 1200],
["DeviceID_Key6_overflow3","Device_ID_Key6",b'\x61' * 2400],
["DeviceID_Key6_overflow4","Device_ID_Key6",b'\x61' * 5000],
["DeviceID_Key6_formatstring","Device_ID_Key6",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Key7_null","Device_ID_Key7",b'\x00'],
["DeviceID_Key7_overflow1","Device_ID_Key7",b'\x61' * 300],
["DeviceID_Key7_overflow2","Device_ID_Key7",b'\x61' * 1200],
["DeviceID_Key7_overflow3","Device_ID_Key7",b'\x61' * 2400],
["DeviceID_Key7_overflow4","Device_ID_Key7",b'\x61' * 5000],
["DeviceID_Key7_formatstring","Device_ID_Key7",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value1_null","Device_ID_Value1",b'\x00'],
["DeviceID_Value1_overflow1","Device_ID_Value1",b'\x61' * 300],
["DeviceID_Value1_overflow2","Device_ID_Value1",b'\x61' * 1200],
["DeviceID_Value1_overflow3","Device_ID_Value1",b'\x61' * 2400],
["DeviceID_Value1_overflow4","Device_ID_Value1",b'\x61' * 5000],
["DeviceID_Value1_formatstring","Device_ID_Value1",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value2_null","Device_ID_Value2",b'\x00'],
["DeviceID_Value2_overflow1","Device_ID_Value2",b'\x61' * 300],
["DeviceID_Value2_overflow2","Device_ID_Value2",b'\x61' * 1200],
["DeviceID_Value2_overflow3","Device_ID_Value2",b'\x61' * 2400],
["DeviceID_Value2_overflow4","Device_ID_Value2",b'\x61' * 5000],
["DeviceID_Value2_formatstring","Device_ID_Value2",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value3_null","Device_ID_Value3",b'\x00'],
["DeviceID_Value3_overflow1","Device_ID_Value3",b'\x61' * 300],
["DeviceID_Value3_overflow2","Device_ID_Value3",b'\x61' * 1200],
["DeviceID_Value3_overflow3","Device_ID_Value3",b'\x61' * 2400],
["DeviceID_Value3_overflow4","Device_ID_Value3",b'\x61' * 5000],
["DeviceID_Value3_formatstring","Device_ID_Value3",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value4_null","Device_ID_Value4",b'\x00'],
["DeviceID_Value4_overflow1","Device_ID_Value4",b'\x61' * 300],
["DeviceID_Value4_overflow2","Device_ID_Value4",b'\x61' * 1200],
["DeviceID_Value4_overflow3","Device_ID_Value4",b'\x61' * 2400],
["DeviceID_Value4_overflow4","Device_ID_Value4",b'\x61' * 5000],
["DeviceID_Value4_formatstring","Device_ID_Value4",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value5_null","Device_ID_Value5",b'\x00'],
["DeviceID_Value5_overflow1","Device_ID_Value5",b'\x61' * 300],
["DeviceID_Value5_overflow2","Device_ID_Value5",b'\x61' * 1200],
["DeviceID_Value5_overflow3","Device_ID_Value5",b'\x61' * 2400],
["DeviceID_Value5_overflow4","Device_ID_Value5",b'\x61' * 5000],
["DeviceID_Value5_formatstring","Device_ID_Value5",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value6_null","Device_ID_Value6",b'\x00'],
["DeviceID_Value6_overflow1","Device_ID_Value6",b'\x61' * 300],
["DeviceID_Value6_overflow2","Device_ID_Value6",b'\x61' * 1200],
["DeviceID_Value6_overflow3","Device_ID_Value6",b'\x61' * 2400],
["DeviceID_Value6_overflow4","Device_ID_Value6",b'\x61' * 5000],
["DeviceID_Value6_formatstring","Device_ID_Value6",b'\x25\x78\x25\x6e\x25\x6e'],
["DeviceID_Value7_null","Device_ID_Value7",b'\x00'],
["DeviceID_Value7_overflow1","Device_ID_Value7",b'\x61' * 300],
["DeviceID_Value7_overflow2","Device_ID_Value7",b'\x61' * 1200],
["DeviceID_Value7_overflow3","Device_ID_Value7",b'\x61' * 2400],
["DeviceID_Value7_overflow4","Device_ID_Value7",b'\x61' * 5000],
["DeviceID_Value7_formatstring","Device_ID_Value7",b'\x25\x78\x25\x6e\x25\x6e']
]

testcases_audio_class = [
["CSInterface1_wTotalLength_null","CSInterface1_wTotalLength",0x0000],
["CSInterface1_wTotalLength_lower","CSInterface1_wTotalLength",0x0001],
["CSInterface1_wTotalLength_higher","CSInterface1_wTotalLength",0x0100],
["CSInterface1_wTotalLength_max","CSInterface1_wTotalLength",0xffff],
["CSInterface1_bInCollection_null","CSInterface1_bInCollection",0x00],
["CSInterface1_bInCollection_lower","CSInterface1_bInCollection",0x01],
["CSInterface1_bInCollection_higher","CSInterface1_bInCollection",0x10],
["CSInterface1_bInCollection_max","CSInterface1_bInCollection",0xff],
["CSInterface1_baInterfaceNr1_null","CSInterface1_baInterfaceNr1",0x00],
["CSInterface1_baInterfaceNr1_lower","CSInterface1_baInterfaceNr1",0x01],
["CSInterface1_baInterfaceNr1_higher","CSInterface1_baInterfaceNr1",0x10],
["CSInterface1_baInterfaceNr1_max","CSInterface1_baInterfaceNr1",0xff],
["CSInterface1_baInterfaceNr2_null","CSInterface1_baInterfaceNr2",0x00],
["CSInterface1_baInterfaceNr2_lower","CSInterface1_baInterfaceNr2",0x01],
["CSInterface1_baInterfaceNr2_higher","CSInterface1_baInterfaceNr2",0x10],
["CSInterface1_baInterfaceNr2_max","CSInterface1_baInterfaceNr2",0xff],
["CSInterface2_bTerminalID_null","CSInterface2_bTerminalID",0x00],
["CSInterface2_bTerminalID_max","CSInterface2_bTerminalID",0xff],
["CSInterface2_wTerminalType_null","CSInterface2_wTerminalType",0x0000],
["CSInterface2_wTerminalType_max","CSInterface2_wTerminalType",0xffff],
["CSInterface2_bAssocTerminal_null","CSInterface2_bAssocTerminal",0x00],
["CSInterface2_bAssocTerminal_max","CSInterface2_bAssocTerminal",0xff],
["CSInterface2_bNrChannel_null","CSInterface2_bNrChannel",0x00],
["CSInterface2_bNrChannel_max","CSInterface2_bNrChannel",0xff],
["CSInterface2_wChannelConfig_null","CSInterface2_wChannelConfig",0x0000],
["CSInterface2_wChannelConfig_max","CSInterface2_wChannelConfig",0xffff],
["CSInterface4_bSourceID_null","CSInterface4_bSourceID",0x00],
["CSInterface4_bSourceID_higher","CSInterface4_bSourceID",0x7f],
["CSInterface4_bSourceID_max","CSInterface4_bSourceID",0xff],
["CSInterface6_bUnitID_null","CSInterface6_bUnitID",0x00],
["CSInterface6_bUnitID_higher","CSInterface6_bUnitID",0x7f],
["CSInterface6_bUnitID_max","CSInterface6_bUnitID",0xff],
["CSInterface6_bSourceID_null","CSInterface4_bSourceID",0x00],
["CSInterface6_bSourceID_higher","CSInterface4_bSourceID",0x7f],
["CSInterface6_bSourceID_max","CSInterface4_bSourceID",0xff],
["CSInterface6_bControlSize_null","CSInterface4_bControlSize",0x00],
["CSInterface6_bControlSize_higher","CSInterface4_bControlSize",0x7f],
["CSInterface6_bControlSize_max","CSInterface4_bControlSize",0xff],
["CSInterface6_bmaControls0_null","CSInterface4_bmaControls0",0x00],
["CSInterface6_bmaControls0_higher","CSInterface4_bmaControls0",0x7f],
["CSInterface6_bmaControls0_max","CSInterface4_bmaControls0",0xff],
["CSInterface6_bmaControls1_null","CSInterface4_bmaControls1",0x00],
["CSInterface6_bmaControls1_higher","CSInterface4_bmaControls1",0x7f],
["CSInterface6_bmaControls1_max","CSInterface4_bmaControls1",0xff],
["CSInterface6_bmaControls2_null","CSInterface4_bmaControls2",0x00],
["CSInterface6_bmaControls2_higher","CSInterface4_bmaControls2",0x7f],
["CSInterface6_bmaControls2_max","CSInterface4_bmaControls2",0xff],
]


testcases_hid_class = [
["HID_bLength_null","HID_bLength",b'\x00'],
["HID_bLength_lower","HID_bLength",b'\x01'],
["HID_bLength_higher","HID_bLength",b'\x50'],
["HID_bLength_max","HID_bLength",b'\xff'],
["HID_bDescriptorType_null","HID_bDescriptorType",b'\x00'],
["HID_bDescriptorType_invalid","HID_bDescriptorType",b'\xff'],
["HID_bCountryCode_invalid","HID_bCountryCode",b'\xff'],
["HID_bNumDescriptors_null","HID_bNumDescriptors",b'\x00'],
["HID_bNumDescriptors_higher","HID_bNumDescriptors",b'\x10'],
["HID_bNumDescriptors_max","HID_bNumDescriptors",b'\xff'],
["HID_bDescriptorType2_null","HID_bDescriptorType2",b'\x00'],
["HID_bDescriptorType2_invalid","HID_bDescriptorType2",b'\xff'],
["HID_wDescriptorLength_null","HID_wDescriptorLength",b'\x00\x00'],
["HID_wDescriptorLength_lower","HID_wDescriptorLength",b'\x10\x00'],
["HID_wDescriptorLength_higher","HID_wDescriptorLength",b'\xff\x00'],
["HID_wDescriptorLength_max","HID_wDescriptorLength",b'\xff\xff'],
["Report_Usage_Page_Logic_error1","Report_Usage_Page",b'\xb1\x01'],
["Report_Usage_Page_Logic_error2","Report_Usage_Page",b'\x81\x01'],
["Report_Usage_Page_Logic_error3","Report_Usage_Page",b'\xff\x01'],
["Report_Usage_Keyboard_Logic_error1","Report_Usage_Keyboard",b'\xb1\x06'],
["Report_Usage_Keyboard_Logic_error2","Report_Usage_Keyboard",b'\x81\x06'],
["Report_Usage_Keyboard_Logic_error3","Report_Usage_Keyboard",b'\xff\x06'],
["Report_Usage_Page_Keyboard_Logic_error1","Report_Usage_Page_Keyboard",b'\xb1\x07'],
["Report_Usage_Page_Keyboard_Logic_error2","Report_Usage_Page_Keyboard",b'\x81\x07'],
["Report_Usage_Page_Keyboard_Logic_error3","Report_Usage_Page_Keyboard",b'\xff\x07'],
["Report_Usage_Minimum1_null","Report_Usage_Minimum1",b'\x19\x00'],
["Report_Usage_Minimum1_lower","Report_Usage_Minimum1",b'\x19\x01'],
["Report_Usage_Minimum1_higher","Report_Usage_Minimum1",b'\x19\xf0'],
["Report_Usage_Minimum1_max","Report_Usage_Minimum1",b'\x19\xff'],
["Report_Usage_Maximum1_null","Report_Usage_Maximum1",b'\x29\x00'],
["Report_Usage_Maximum1_lower","Report_Usage_Maximum1",b'\x29\x01'],
["Report_Usage_Maximum1_higher","Report_Usage_Maximum1",b'\x29\xf0'],
["Report_Usage_Maximum1_max","Report_Usage_Maximum1",b'\x29\xff'],
["Report_Logical_Minimum1_null","Report_Logical_Minimum1",b'\x15\x00'],
["Report_Logical_Minimum1_lower","Report_Logical_Minimum1",b'\x15\x01'],
["Report_Logical_Minimum1_higher","Report_Logical_Minimum1",b'\x15\xf0'],
["Report_Logical_Minimum1_max","Report_Logical_Minimum1",b'\x15\xff'],
["Report_Logical_Maximum1_null","Report_Logical_Maximum1",b'\x25\x00'],
["Report_Logical_Maximum1_lower","Report_Logical_Maximum1",b'\x25\x01'],
["Report_Logical_Maximum1_higher","Report_Logical_Maximum1",b'\x25\xf0'],
["Report_Logical_Maximum1_max","Report_Logical_Maximum1",b'\x25\xff'],
["Report_Report_Size1_null","Report_Report_Size1",b'\x75\x00'],
["Report_Report_Size1_lower","Report_Report_Size1",b'\x75\x01'],
["Report_Report_Size1_higher","Report_Report_Size1",b'\x75\xf0'],
["Report_Report_Size1_max","Report_Report_Size1",b'\x75\xff'],
["Report_Report_Count1_null","Report_Report_Count1",b'\x95\x00'],
["Report_Report_Count1_lower","Report_Report_Count1",b'\x95\x01'],
["Report_Report_Count1_higher","Report_Report_Count1",b'\x95\xf0'],
["Report_Report_Count1_max","Report_Report_Count1",b'\x95\xff'],
["Report_Input_Data_Variable_Absolute_Bitfield_null","Report_Input_Data_Variable_Absolute_Bitfield",b'\x81\x00'],
["Report_Input_Data_Variable_Absolute_Bitfield_max","Report_Input_Data_Variable_Absolute_Bitfield",b'\x81\xff'],
["Report_Input_Data_Variable_Absolute_Bitfield_invalid","Report_Input_Data_Variable_Absolute_Bitfield",b'\x05\x02'],
["Report_Report_Count2_null","Report_Report_Count2",b'\x95\x00'],
["Report_Report_Count2_lower","Report_Report_Count2",b'\x95\x01'],
["Report_Report_Count2_higher","Report_Report_Count2",b'\x95\xf0'],
["Report_Report_Count2_max","Report_Report_Count2",b'\x95\xff'],
["Report_Report_Size2_null","Report_Report_Size2",b'\x75\x00'],
["Report_Report_Size2_lower","Report_Report_Size2",b'\x75\x01'],
["Report_Report_Size2_higher","Report_Report_Size2",b'\x75\xf0'],
["Report_Report_Size2_max","Report_Report_Size2",b'\x75\xff'],
["Report_Input_Constant_Array_Absolute_Bitfield_null","Report_Input_Constant_Array_Absolute_Bitfield",b'\x81\x00'],
["Report_Input_Constant_Array_Absolute_Bitfield_max","Report_Input_Constant_Array_Absolute_Bitfield",b'\x81\xff'],
["Report_Input_Constant_Array_Absolute_Bitfield_invalid","Report_Input_Constant_Array_Absolute_Bitfield",b'\x05\x01'],
["Report_Usage_Minimum2_null","Report_Usage_Minimum2",b'\x19\x00'],
["Report_Usage_Minimum2_lower","Report_Usage_Minimum2",b'\x19\x01'],
["Report_Usage_Minimum2_higher","Report_Usage_Minimum2",b'\x19\xf0'],
["Report_Usage_Minimum2_max","Report_Usage_Minimum2",b'\x19\xff'],
["Report_Usage_Maximum2_null","Report_Usage_Maximum2",b'\x29\x00'],
["Report_Usage_Maximum2_lower","Report_Usage_Maximum2",b'\x29\x01'],
["Report_Usage_Maximum2_higher","Report_Usage_Maximum2",b'\x29\xf0'],
["Report_Usage_Maximum2_max","Report_Usage_Maximum2",b'\x29\xff'],
["Report_Logical_Minimum2_null","Report_Logical_Minimum2",b'\x15\x00'],
["Report_Logical_Minimum2_lower","Report_Logical_Minimum2",b'\x15\x01'],
["Report_Logical_Minimum2_higher","Report_Logical_Minimum2",b'\x15\xf0'],
["Report_Logical_Minimum2_max","Report_Logical_Minimum2",b'\x15\xff'],
["Report_Logical_Maximum2_null","Report_Logical_Maximum2",b'\x25\x00'],
["Report_Logical_Maximum2_lower","Report_Logical_Maximum2",b'\x25\x01'],
["Report_Logical_Maximum2_higher","Report_Logical_Maximum2",b'\x25\xf0'],
["Report_Logical_Maximum2_max","Report_Logical_Maximum2",b'\x25\xff'],
["Report_Report_Size3_null","Report_Report_Size3",b'\x75\x00'],
["Report_Report_Size3_lower","Report_Report_Size3",b'\x75\x01'],
["Report_Report_Size3_higher","Report_Report_Size3",b'\x75\xf0'],
["Report_Report_Size3_max","Report_Report_Size3",b'\x75\xff'],
["Report_Report_Count3_null","Report_Report_Count3",b'\x95\x00'],
["Report_Report_Count3_lower","Report_Report_Count3",b'\x95\x01'],
["Report_Report_Count3_higher","Report_Report_Count3",b'\x95\xf0'],
["Report_Report_Count3_max","Report_Report_Count3",b'\x95\xff'],
["Report_Input_Data_Array_Absolute_Bitfield_null","Report_Input_Data_Array_Absolute_Bitfield",b'\x81\x00'],
["Report_Input_Data_Array_Absolute_Bitfield_max","Report_Input_Data_Array_Absolute_Bitfield",b'\x81\xff'],
["Report_Input_Data_Array_Absolute_Bitfield_invalid","Report_Input_Data_Array_Absolute_Bitfield",b'\x05\x00'],
["Report_End_Collection_null","Report_End_Collection",b'\x00'],
["Report_End_Collection_max","Report_End_Collection",b'\xff']

]


testcases_smartcard_class = [
["icc_bLength_null","icc_bLength",b'\x00'],
["icc_bLength_lower","icc_bLength",b'\x01'],
["icc_bLength_higher","icc_bLength",b'\x50'],
["icc_bLength_max","icc_bLength",b'\xff'],
["icc_bDescriptorType_null","icc_bDescriptorType",b'\x00'],
["icc_bDescriptorType_invalid","icc_bDescriptorType",b'\xff'],
["icc_bMaxSlotIndex_higher","icc_bMaxSlotIndex",b'\x50'],
["icc_bMaxSlotIndex_max","icc_bMaxSlotIndex",b'\xff'],
["icc_bVoltageSupport_null","icc_bVoltageSupport",b'\x00'],
["icc_bVoltageSupport_lower","icc_bVoltageSupport",b'\x01'],
["icc_bVoltageSupport_higher","icc_bVoltageSupport",b'\x50'],
["icc_bVoltageSupport_max","icc_bVoltageSupport",b'\xff'],
["icc_dwProtocols_null","icc_dwProtocols",b'\x00\x00\x00\x00'],
["icc_dwProtocols_max","icc_dwProtocols",b'\xff\xff\xff\xff'],
["icc_dwDefaultClock_null","icc_dwDefaultClock",b'\x00\x00\x00\x00'],
["icc_dwDefaultClock_max","icc_dwDefaultClock",b'\xff\xff\xff\xff'],
["icc_dwMaximumClock_null","icc_dwMaximumClock",b'\x00\x00\x00\x00'],
["icc_dwMaximumClock_max","icc_dwMaximumClock",b'\xff\xff\xff\xff'],
["icc_bNumClockSupported_higher","icc_bNumClockSupported",b'\x50'],
["icc_bNumClockSupported_max","icc_bNumClockSupported",b'\xff'],
["icc_dwDataRate_null","icc_dwDataRate",b'\x00\x00\x00\x00'],
["icc_dwDataRate_max","icc_dwDataRate",b'\xff\xff\xff\xff'],
["icc_dwMaxDataRate_null","icc_dwMaxDataRate",b'\x00\x00\x00\x00'],
["icc_dwMaxDataRate_max","icc_dwMaxDataRate",b'\xff\xff\xff\xff'],
["icc_bNumDataRatesSupported_higher","icc_bNumDataRatesSupported",b'\x50'],
["icc_bNumDataRatesSupported_max","icc_bNumDataRatesSupported",b'\xff'],
["icc_dwMaxIFSD_null","icc_dwMaxIFSD",b'\x00\x00\x00\x00'],
["icc_dwMaxIFSD_max","icc_dwMaxIFSD",b'\xff\xff\xff\xff'],
["icc_dwSynchProtocols_null","icc_dwSynchProtocols",b'\x00\x00\x00\x00'],
["icc_dwSynchProtocols_max","icc_dwSynchProtocols",b'\xff\xff\xff\xff'],
["icc_dwMechanical_null","icc_dwMechanical",b'\x00\x00\x00\x00'],
["icc_dwMechanical_max","icc_dwMechanical",b'\xff\xff\xff\xff'],
["icc_dwFeatures_null","icc_dwFeatures",b'\x00\x00\x00\x00'],
["icc_dwFeatures_max","icc_dwFeatures",b'\xff\xff\xff\xff'],
["icc_dwMaxCCIDMessageLength_null","icc_dwMaxCCIDMessageLength",b'\x00\x00\x00\x00'],
["icc_dwMaxCCIDMessageLength_max","icc_dwMaxCCIDMessageLength",b'\xff\xff\xff\xff'],
["icc_bClassGetResponse_higher","icc_bClassGetResponse",b'\x50'],
["icc_bClassGetResponse_max","icc_bClassGetResponse",b'\xff'],
["icc_bClassEnvelope_higher","icc_bClassEnvelope",b'\x50'],
["icc_bClassEnvelope_max","icc_bClassEnvelope",b'\xff'],
["icc_wLcdLayout_higher","icc_wLcdLayout",b'\x50\x50'],
["icc_wLcdLayout_max","icc_wLcdLayout",b'\xff\xff'],
["icc_bPinSupport_higher","icc_bPinSupport",b'\x50'],
["icc_bPinSupport_max","icc_bPinSupport",b'\xff'],
["icc_bMaxCCIDBusySlots_null","icc_bMaxCCIDBusySlots",b'\x00'],
["icc_bMaxCCIDBusySlots_higher","icc_bMaxCCIDBusySlots",b'\x50'],
["icc_bMaxCCIDBusySlots_max","icc_bMaxCCIDBusySlots",b'\xff'],
["SetParameters_bMessageType_null","SetParameters_bMessageType",b'\x00'],
["SetParameters_bMessageType_max","SetParameters_bMessageType",b'\xff'],
["SetParameters_dwLength_null","SetParameters_dwLength",b'\x00\x00\x00\x00'],
["SetParameters_dwLength_lower","SetParameters_dwLength",b'\x01\x00\x00\x00'],
["SetParameters_dwLength_higher","SetParameters_dwLength",b'\x7f\x00\x00\x00'],
["SetParameters_dwLength_max","SetParameters_dwLength",b'\xff\xff\xff\xff'],
["SetParameters_bSlot_invalid","SetParameters_bSlot",b'\xff'],
["SetParameters_bStatus_invalid","SetParameters_bStatus",b'\xff'],
["SetParameters_bError_invalid","SetParameters_bError",b'\xff'],
["SetParameters_bProtocolNum_invalid","SetParameters_bProtocolNum",b'\xff'],
["IccPowerOn_bMessageType_null","IccPowerOn_bMessageType",b'\x00'],
["IccPowerOn_bMessageType_max","IccPowerOn_bMessageType",b'\xff'],
["IccPowerOn_dwLength_null","IccPowerOn_dwLength",b'\x00\x00\x00\x00'],
["IccPowerOn_dwLength_lower","IccPowerOn_dwLength",b'\x01\x00\x00\x00'],
["IccPowerOn_dwLength_higher","IccPowerOn_dwLength",b'\x7f\x00\x00\x00'],
["IccPowerOn_dwLength_max","IccPowerOn_dwLength",b'\xff\xff\xff\xff'],
["IccPowerOn_bSlot_invalid","IccPowerOn_bSlot",b'\xff'],
["IccPowerOn_bStatus_invalid","IccPowerOn_bStatus",b'\xff'],
["IccPowerOn_bError_invalid","IccPowerOn_bError",b'\xff'],
["IccPowerOn_bChainParameter_invalid","IccPowerOn_bChainParameter",b'\xff'],
["IccPowerOff_bMessageType_null","IccPowerOff_bMessageType",b'\x00'],
["IccPowerOff_bMessageType_max","IccPowerOff_bMessageType",b'\xff'],
["IccPowerOff_dwLength_null","IccPowerOff_dwLength",b'\x00\x00\x00\x00'],
["IccPowerOff_dwLength_lower","IccPowerOff_dwLength",b'\x01\x00\x00\x00'],
["IccPowerOff_dwLength_higher","IccPowerOff_dwLength",b'\x7f\x00\x00\x00'],
["IccPowerOff_dwLength_max","IccPowerOff_dwLength",b'\xff\xff\xff\xff'],
["IccPowerOff_bSlot_invalid","IccPowerOff_bSlot",b'\xff'],
["IccPowerOff_abRFU_invalid","IccPowerOff_abRFU",b'\xff'],
["XfrBlock_bMessageType_null","XfrBlock_bMessageType",b'\x00'],
["XfrBlock_bMessageType_max","XfrBlock_bMessageType",b'\xff'],
["XfrBlock_dwLength_null","XfrBlock_dwLength",b'\x00\x00\x00\x00'],
["XfrBlock_dwLength_lower","XfrBlock_dwLength",b'\x01\x00\x00\x00'],
["XfrBlock_dwLength_higher","XfrBlock_dwLength",b'\x7f\x00\x00\x00'],
["XfrBlock_dwLength_max","XfrBlock_dwLength",b'\xff\xff\xff\xff'],
["XfrBlock_bSlot_invalid","XfrBlock_bSlot",b'\xff'],
["XfrBlock_bStatus_invalid","XfrBlock_bStatus",b'\xff'],
["XfrBlock_bError_invalid","XfrBlock_bError",b'\xff'],
["XfrBlock_bChainParameter_invalid","XfrBlock_bChainParameter",b'\xff'],
["SetDataRateAndClockFrequency_bMessageType_null","SetDataRateAndClockFrequency_bMessageType",b'\x00'],
["SetDataRateAndClockFrequency_bMessageType_max","SetDataRateAndClockFrequency_bMessageType",b'\xff'],
["SetDataRateAndClockFrequency_dwLength_null","SetDataRateAndClockFrequency_dwLength",b'\x00\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwLength_lower","SetDataRateAndClockFrequency_dwLength",b'\x01\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwLength_higher","SetDataRateAndClockFrequency_dwLength",b'\x7f\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwLength_max","SetDataRateAndClockFrequency_dwLength",b'\xff\xff\xff\xff'],
["SetDataRateAndClockFrequency_bSlot_invalid","SetDataRateAndClockFrequency_bSlot",b'\xff'],
["SetDataRateAndClockFrequency_bStatus_invalid","SetDataRateAndClockFrequency_bStatus",b'\xff'],
["SetDataRateAndClockFrequency_bError_invalid","SetDataRateAndClockFrequency_bError",b'\xff'],
["SetDataRateAndClockFrequency_bRFU_invalid","SetDataRateAndClockFrequency_bRFU",b'\xff'],
["SetDataRateAndClockFrequency_dwClockFrequency_null","SetDataRateAndClockFrequency_dwClockFrequency",b'\x00\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwClockFrequency_lower","SetDataRateAndClockFrequency_dwClockFrequency",b'\x01\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwClockFrequency_higher","SetDataRateAndClockFrequency_dwClockFrequency",b'\x7f\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwClockFrequency_max","SetDataRateAndClockFrequency_dwClockFrequency",b'\xff\xff\xff\xff'],
["SetDataRateAndClockFrequency_dwDataRate_null","SetDataRateAndClockFrequency_dwDataRate",b'\x00\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwDataRate_lower","SetDataRateAndClockFrequency_dwDataRate",b'\x01\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwDataRate_higher","SetDataRateAndClockFrequency_dwDataRate",b'\x7f\x00\x00\x00'],
["SetDataRateAndClockFrequency_dwDataRate_max","SetDataRateAndClockFrequency_dwDataRate",b'\xff\xff\xff\xff']

]

testcases_mass_storage_class = [
["inquiry_peripheral_max","inquiry_peripheral",b'\xff'],
["inquiry_RMB_null","inquiry_RMB",b'\x00'],
["inquiry_RMB_max","inquiry_RMB",b'\xff'],
["inquiry_version_invalid","inquiry_version",b'\xff'],
["inquiry_response_data_format_invalid","inquiry_version",b'\xff'],
["inquiry_config1_invalid","inquiry_version",b'\xff'],
["inquiry_config2_invalid","inquiry_version",b'\xff'],
["inquiry_config3_invalid","inquiry_version",b'\xff'],
["inquiry_vendor_id_formatstring","inquiry_vendor_id",b'%x%x%n%n'],
["inquiry_vendor_id_overflow1","inquiry_vendor_id",b'a' * 20],
["inquiry_vendor_id_overflow2","inquiry_vendor_id",b'a' * 50],
["inquiry_vendor_id_overflow3","inquiry_vendor_id",b'a' * 100],
["inquiry_vendor_id_overflow4","inquiry_vendor_id",b'a' * 255],
["inquiry_product_id_formatstring","inquiry_product_id",b'%x%x%x%x%x%x%n%n'],
["inquiry_product_id_overflow1","inquiry_product_id",b'a' * 20],
["inquiry_product_id_overflow2","inquiry_product_id",b'a' * 50],
["inquiry_product_id_overflow3","inquiry_product_id",b'a' * 100],
["inquiry_product_id_overflow4","inquiry_product_id",b'a' * 255],
["inquiry_product_revision_level_formatstring","inquiry_product_revision_level",b'%x%n'],
["inquiry_product_revision_level_overflow1","inquiry_product_revision_level",b'a' * 20],
["inquiry_product_revision_level_overflow2","inquiry_product_revision_level",b'a' * 50],
["inquiry_product_revision_level_overflow3","inquiry_product_revision_level",b'a' * 100],
["inquiry_product_revision_level_overflow4","inquiry_product_revision_level",b'a' * 255],
["read_capacity_logical_block_address_null","read_capacity_logical_block_address",b'\x00\x00\x00\x00'],
["read_capacity_logical_block_address_lower","read_capacity_logical_block_address",b'\x00\x00\x00\x01'],
["read_capacity_logical_block_address_higher","read_capacity_logical_block_address",b'\x00\xff\x00\x00'],
["read_capacity_logical_block_address_max","read_capacity_logical_block_address",b'\xff\xff\xff\xff'],
["read_capacity_length_null","read_capacity_length",b'\x00\x00\x00\x00'],
["read_capacity_length_lower","read_capacity_length",b'\x01\x00\x00\x01'],
["read_capacity_length_higher","read_capacity_length",b'\x00\xff\x00\x00'],
["read_capacity_length_max","read_capacity_length",b'\xff\xff\xff\xff'],
["read_format_capacity_capacity_list_length_null","read_format_capacity_capacity_list_length",b'\x00\x00\x00\x00'],
["read_format_capacity_capacity_list_length_lower","read_format_capacity_capacity_list_length",b'\x01\x00\x00\x01'],
["read_format_capacity_capacity_list_length_higher","read_format_capacity_capacity_list_length",b'\x00\xff\x00\x00'],
["read_format_capacity_capacity_list_length_max","read_format_capacity_capacity_list_length",b'\xff\xff\xff\xff'],
["read_format_capacity_number_of_blocks_null","read_format_capacity_number_of_blocks",b'\x00\x00\x00\x00'],
["read_format_capacity_number_of_blocks_lower","read_format_capacity_number_of_blocks",b'\x00\x00\x00\x01'],
["read_format_capacity_number_of_blocks_higher","read_format_capacity_number_of_blocks",b'\x00\xff\x00\x00'],
["read_format_capacity_number_of_blocks_max","read_format_capacity_number_of_blocks",b'\xff\xff\xff\xff'],
["read_format_capacity_descriptor_type_invalid","read_format_capacity_descriptor_type",b'\xff'],
["read_format_capacity_block_length_null","read_format_capacity_block_length",b'\x00\x00\x00'],
["read_format_capacity_block_length_lower","read_format_capacity_block_length",b'\x00\x01\x00'],
["read_format_capacity_block_length_higher","read_format_capacity_block_length",b'\x00\xff\xff'],
["read_format_capacity_block_length_max","read_format_capacity_block_length",b'\xff\xff\xff'],
["mode_sense_length_null","mode_sense_length",b'\x00'],
["mode_sense_length_lower","mode_sense_length",b'\x01'],
["mode_sense_length_higher","mode_sense_length",b'\x7f'],
["mode_sense_length_max","mode_sense_length",b'\xff'],
["mode_sense_medium_type_higher","mode_sense_medium_type",b'\x7f'],
["mode_sense_medium_type_max","mode_sense_medium_type",b'\xff'],
["mode_sense_device_specific_param_higher","mode_sense_device_specific_param",b'\x7f'],
["mode_sense_device_specific_param_max","mode_sense_device_specific_param",b'\xff'],
["mode_sense_block_descriptor_len_higher","mode_sense_block_descriptor_len",b'\x7f'],
["mode_sense_block_descriptor_len_max","mode_sense_block_descriptor_len",b'\xff']
]


testcases_hub_class = [
["hub_bLength_null","hub_bLength",0x00],
["hub_bLength_lower","hub_bLength",0x01],
["hub_bLength_higher","hub_bLength",0x7f],
["hub_bLength_max","hub_bLength",0xff],
["hub_bDescriptorType_null","hub_bDescriptorType",0x00],
["hub_bDescriptorType_invalid","hub_bDescriptorType",0xff],
["hub_bNbrPorts_null","hub_bNbrPorts",0x00],
["hub_bNbrPorts_lower","hub_bNbrPorts",0x01],
["hub_bNbrPorts_higher","hub_bNbrPorts",0x7f],
["hub_bNbrPorts_max","hub_bNbrPorts",0xff],
["hub_wHubCharacteristics_null","hub_wHubCharacteristics",0x0000],
["hub_wHubCharacteristics_max","hub_wHubCharacteristics",0xffff],
["hub_bHubContrCurrent_null","hub_bHubContrCurrent",0x00],
["hub_bHubContrCurrent_lower","hub_bHubContrCurrent",0x01],
["hub_bHubContrCurrent_higher","hub_bHubContrCurrent",0x7f],
["hub_bHubContrCurrent_max","hub_bHubContrCurrent",0xff]
]



