/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.digest.DigestUtils;

public class WSConnection {
    protected static String[] ACTION_CAN_BE_TAKEN = new String[]{"...", "The URL is neither HTTP nor HTTPS: No action will be taken", "Malformed URL: No action will be taken", "I/O Exception: No action will be taken", "Starting to send the above HTTP request", "Starting to send the above HTTPS request"};
    protected static String[] RESPONSE_MESSAGES = new String[]{"...", "I/O Exception: While attempting to connect", "Response received"};
    private int action = 0;
    private int response = 0;
    private URLConnection connection = null;

    public WSConnection(String knock) {
        try {
            URL knockURL = new URL(knock);
            if (knockURL.getProtocol().toLowerCase().equals("https")) {
                this.action = 5;
                WSConnection.trustAllHosts();
                HttpsURLConnection https = (HttpsURLConnection)knockURL.openConnection();
                https.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                this.connection = https;
            } else {
                this.action = 4;
                this.connection = (HttpURLConnection)knockURL.openConnection();
            }
            this.setRequestProperties();
        }
        catch (MalformedURLException e) {
            this.action = 2;
        }
        catch (IOException e) {
            this.action = 3;
        }
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setRequestProperties() {
        this.connection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        this.connection.setRequestProperty("Accept-Encoding", "gzip,deflate,sdch");
        this.connection.setRequestProperty("Accept-Language", "en-US,en;q=0.8,el;q=0.6");
        this.connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36");
    }

    public void sendRequest() {
        if (this.action == 4 || this.action == 5) {
            try {
                this.connection.connect();
                this.response = 2;
            }
            catch (IOException e) {
                this.response = 1;
            }
        }
    }

    public String responseCode() {
        if (this.action == 4) {
            try {
                return "" + ((HttpURLConnection)this.connection).getResponseCode();
            }
            catch (IOException e) {
                return "---";
            }
        }
        if (this.action == 5) {
            try {
                return "" + ((HttpsURLConnection)this.connection).getResponseCode();
            }
            catch (IOException e) {
                return "***";
            }
        }
        return "000";
    }

    public String getActionToBeTaken() {
        return ACTION_CAN_BE_TAKEN[this.action];
    }

    public String responseMessage() {
        return RESPONSE_MESSAGES[this.response];
    }

    public boolean isHttps() {
        return this.connection instanceof HttpsURLConnection;
    }

    public String getCertificateAlgorithm() throws SSLPeerUnverifiedException {
        Certificate[] certs = ((HttpsURLConnection)this.connection).getServerCertificates();
        return certs[0].getPublicKey().getAlgorithm();
    }

    public String getCertificateFingerprint() throws SSLPeerUnverifiedException, CertificateEncodingException {
        Certificate[] certs = ((HttpsURLConnection)this.connection).getServerCertificates();
        return WSConnection.formatWithColons(DigestUtils.sha1Hex(certs[0].getEncoded()).toUpperCase(Locale.ENGLISH));
    }

    public String getCertSHA1Hash() {
        StringBuffer hashCode = new StringBuffer("SSL Check - ");
        if (this.action == 5) {
            try {
                hashCode.append(this.getCertificateAlgorithm());
                hashCode.append(" key fingerprint is (SHA1) ");
                hashCode.append(this.getCertificateFingerprint());
                hashCode.append(".");
            }
            catch (SSLPeerUnverifiedException e) {
                hashCode.append("No Certificate Hash Values");
            }
            catch (CertificateEncodingException e) {
                hashCode.append("Certificate Encoding Exception");
            }
            catch (IllegalStateException e) {
                hashCode.append("Illegal State Exception");
            }
        }
        return hashCode.toString();
    }

    private static String formatWithColons(String input) {
        StringBuilder sb = new StringBuilder();
        char[] inputCharArray = input.toCharArray();
        for (int count = 0; count < inputCharArray.length; ++count) {
            if (count % 2 == 0 && count != 0) {
                sb.append(':');
            }
            sb.append(inputCharArray[count]);
        }
        return sb.toString();
    }
}

