/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import net.seleucus.wsp.server.WSServer;

public class WSAction
implements Callable<Boolean> {
    private StringBuilder stdOutBuilder;
    private StringBuilder stdErrorBuilder;
    private boolean hasExecuted;
    private boolean wasSuccessful;
    private final String command;
    private final WSServer myServer;
    private final int action;
    private final int ppID;
    private final String ipAddress;

    public WSAction(WSServer myServer, int ppID, int action, String ipAddress) {
        this.myServer = myServer;
        this.action = action;
        this.ppID = ppID;
        this.ipAddress = ipAddress;
        this.command = myServer.getWSDatabase().actionsAvailable.getOSCommand(ppID, action);
        this.stdOutBuilder = new StringBuilder();
        this.stdErrorBuilder = new StringBuilder();
        this.hasExecuted = false;
        this.wasSuccessful = false;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean getHasExecuted() {
        return this.hasExecuted;
    }

    public boolean getWasSuccessful() {
        return this.wasSuccessful;
    }

    public String getStdOut() {
        return this.stdOutBuilder.toString();
    }

    public String getStdErr() {
        return this.stdErrorBuilder.toString();
    }

    protected boolean runCommand(String command) {
        boolean success = false;
        try {
            Process myProcess = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(myProcess.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(myProcess.getErrorStream()));
            this.getInputStreamText(stdInput, this.stdOutBuilder);
            this.getInputStreamText(stdError, this.stdErrorBuilder);
            success = true;
        }
        catch (IOException e) {
            success = false;
        }
        this.myServer.getWSDatabase().actionsAvailable.updateAction(this.ppID, this.action, success, this.ipAddress);
        return success;
    }

    private void getInputStreamText(BufferedReader inputReader, StringBuilder textBuilder) throws IOException {
        int value;
        for (int counter = 0; (value = inputReader.read()) > 0 && counter <= 65535; ++counter) {
            textBuilder.append((char)value);
        }
    }

    @Override
    public Boolean call() {
        if (!this.hasExecuted) {
            this.wasSuccessful = this.runCommand(this.command);
        }
        this.hasExecuted = true;
        return this.wasSuccessful;
    }
}

