/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server.commands;

import net.seleucus.wsp.server.WSServer;
import net.seleucus.wsp.server.commands.WSCommandOption;

public class WSActionAdd
extends WSCommandOption {
    public WSActionAdd(WSServer myServer) {
        super(myServer);
    }

    @Override
    protected void execute() {
        String users = this.myServer.getWSDatabase().users.showUsers();
        this.myServer.println(users);
        int ppID = this.myServer.readLineOptionalInt("Select a User ID");
        boolean userIDFound = this.myServer.getWSDatabase().passPhrases.isPPIDInUse(ppID);
        if (!userIDFound) {
            this.myServer.println("User ID Not Found");
        } else {
            this.myServer.println("The existing actions for this user are: ");
            String actions = this.myServer.getWSDatabase().actionsAvailable.showActions(ppID);
            this.myServer.println(actions);
            String osCommand = this.myServer.readLineRequired("Enter the new O/S Command");
            int action = this.myServer.readLineRequiredInt("Select an action number for this O/S Command", 0, 9);
            boolean actionNumberInUse = this.myServer.getWSDatabase().actionsAvailable.isActionNumberInUse(ppID, action);
            if (!actionNumberInUse) {
                this.myServer.getWSDatabase().actionsAvailable.addAction(ppID, osCommand, action);
            } else {
                this.myServer.println("I am sorry, that Action Number is already in Use");
            }
        }
    }

    @Override
    public boolean handle(String cmd) {
        boolean validCommand = false;
        if (this.isValid(cmd)) {
            validCommand = true;
            this.execute();
        }
        return validCommand;
    }

    @Override
    protected boolean isValid(String cmd) {
        boolean valid = false;
        if (cmd.equalsIgnoreCase("action add")) {
            valid = true;
        }
        return valid;
    }
}

