/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server.commands;

import net.seleucus.wsp.server.WSServer;
import net.seleucus.wsp.server.commands.WSCommandOption;

public class WSActionShow
extends WSCommandOption {
    public WSActionShow(WSServer myServer) {
        super(myServer);
    }

    @Override
    protected void execute() {
        String users = this.myServer.getWSDatabase().users.showUsers();
        this.myServer.println(users);
        int ppID = this.myServer.readLineOptionalInt("Select a User ID");
        boolean userIDFound = this.myServer.getWSDatabase().passPhrases.isPPIDInUse(ppID);
        if (!userIDFound) {
            this.myServer.println("User ID Not Found");
        } else {
            String actions = this.myServer.getWSDatabase().actionsAvailable.showActions(ppID);
            this.myServer.println(actions);
            int actionNumber = this.myServer.readLineOptionalInt("Select an Action Number");
            String actionDetails = this.myServer.getWSDatabase().actionsAvailable.showActionDetails(ppID, actionNumber);
            this.myServer.println(actionDetails);
        }
    }

    @Override
    public boolean handle(String cmd) {
        boolean validCommand = false;
        if (this.isValid(cmd)) {
            validCommand = true;
            this.execute();
        }
        return validCommand;
    }

    @Override
    protected boolean isValid(String cmd) {
        boolean valid = false;
        if (cmd.equalsIgnoreCase("action show")) {
            valid = true;
        }
        return valid;
    }
}

