#!/usr/bin/python

import os
import sys

DETECTION_TRICKS = {
	"Red Pill":"\x0f\x01\x0d\x00\x00\x00\x00\xc3",
	"VirtualPc trick":"\x0f\x3f\x07\x0b",
	"VMware trick":"VMXh",
	"VMCheck.dll":"\x45\xC7\x00\x01",
	"VMCheck.dll for VirtualPC":"\x0f\x3f\x07\x0b\xc7\x45\xfc\xff\xff\xff\xff",
	"Xen":"XenVMM", # Or XenVMMXenVMM
	"Bochs & QEmu CPUID Trick":"\x44\x4d\x41\x63",
	"Torpig VMM Trick": "\xE8\xED\xFF\xFF\xFF\x25\x00\x00\x00\xFF\x33\xC9\x3D\x00\x00\x00\x80\x0F\x95\xC1\x8B\xC1\xC3",
	"Torpig (UPX) VMM Trick": "\x51\x51\x0F\x01\x27\x00\xC1\xFB\xB5\xD5\x35\x02\xE2\xC3\xD1\x66\x25\x32\xBD\x83\x7F\xB7\x4E\x3D\x06\x80\x0F\x95\xC1\x8B\xC1\xC3"
	}

DEBUGGING_TRICKS = {
	"""
	
	Should be this way but, well, Python is a shit to analyze an string with the char '\'.
	
	"%%.%SICE":"SoftIce detection",
	"%%.%SIWVID":"SoftIce detection",
	"%%.%NTICE":"SoftIce detection",
	"%%.%REGSYS":"Regmon detection",
	"%%.%REGVXG":"Regmon detection",
	"%%.%FILEVXG":"Filemon detection",
	"%%.%FILEM":"Filemon detection",
	"%%.%TRW":"TRW detection",
	"%%.%TWX":"TRW detection",
	"%%.%ICEEXT":"SoftIce detection",
	"%%.%NTFIRE.S":"'DemoVDD By elicz' technique",
	"""
	"SICE":"SoftIce detection",
	"SIWVID":"SoftIce detection",
	"NTICE":"SoftIce detection",
	"REGSYS":"Regmon detection",
	"REGVXG":"Regmon detection",
	"FILEVXG":"Filemon detection",
	"FILEM":"Filemon detection",
	"TRW":"TRW detection",
	"TWX":"TRW detection",
	"ICEEXT":"SoftIce detection",
	"NTFIRE.S":"'DemoVDD By elicz' technique",
	"OLLYDBG":"OllyDbg detection",
	"FileMonClass":"Filemon detection",
	"isDebuggerPresent":"Generic debugger detection",
	"CheckRemoteDebuggerPresent":"Generic debugger detection",
	"OutputDebugString":"Generic debugger detection",
	"SoftICE":"SoftIce detection",
	"Compuware":"SoftIce detection",
	"NuMega":"SoftIce detection",
	"WinDbgFrameClass":"WinDbg detection",
	"GBDYLLO": "Themida's tricks",
	"pediy0":"Themida's tricks",
	"PROCMON_WINDOW_CLASS":"Process Monitor"
	}

def main(the_file):

    try:
        f = file(the_file, "rb")
    except:
        print "Error opening file:", sys.exc_info()[1]
        sys.exit(1)

    buf = f.read()
    f.close()

    tricks = check_tricks(buf)

    if len(tricks) > 0:
        for trick in tricks:
            print "***Detected trick %s" % trick

        print
        print "Total of %d trick(s) detected." % len(ret)
    else:
        print "No trick detected."

def check_trick_from_file(the_file):
    f = file(the_file, "rb")
    buf = f.read()
    f.close()

    return check_tricks(buf)

def check_tricks(buf):
    tricks = 0
    ret = []
    for trick in DETECTION_TRICKS:
        if buf.lower().find(DETECTION_TRICKS[trick].lower())>-1:
            ret.append(trick)

    return ret

def usage():
    print "Usage:", sys.argv[0], "<file>"

def banner():
    print "Virtual Machine Trick's Detector v0.1 - Joxean Koret "
    print

if __name__ == "__main__":
    banner()
    if len(sys.argv) == 1:
        usage()
        sys.exit(1)
    else:
        main(sys.argv[1])


