#include <windows.h>
#include <stdio.h>
#include <sys/stat.h>

#define SOFTICE_STRINGS_LEN 5

char *SOFTICE_STRINGS[] = {"\\\\.\\NTICE", "\\\\.\\SICE", "\\\\.\\SIWVID", "\\\\.\\NTICE", "\\\\.\\ICEEXT"};

int check_wine(void)
{
char strWinDir[256];
char strFilename[256];
struct stat file_stat;

	if (GetWindowsDirectory(strWinDir, 255))
	{
		sprintf(strFilename, "%s\\explorer.exe", strWinDir);
		stat(strFilename, &file_stat);

		return file_stat.st_size < 2000 ? 1 : 0;
	}
	
	return(0);
}

int check_vmrpill (void)
{
/**
 * The following 2 instructions:
 *
 *  sidt[0x0];
 *  ret;
 *
*/
unsigned char m[2+4], rpill[] = "\x0f\x01\x0d\x00\x00\x00\x00\xc3";

	*((unsigned*)&rpill[3]) = (unsigned)m;
	((void(*)())&rpill)();

	if (m[5]>0xd0)
		return(1);
	else
		return(0);
}

int check_softice_variant(char *str_file)
{
	HANDLE hFile=CreateFile(str_file, 
							GENERIC_READ | GENERIC_WRITE, 
							FILE_SHARE_READ | FILE_SHARE_WRITE, 
							NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); 

	if(hFile!=INVALID_HANDLE_VALUE)
	{
		CloseHandle(hFile);
		return (1);
	}

	return(0); 
}

int check_softice(void)
{
	for (int i; i<SOFTICE_STRINGS_LEN;i++)
		if (check_softice_variant(SOFTICE_STRINGS[i]) == 1)
			return(1);

	return(0);
}


int check_debug(void)
{
	if (IsDebuggerPresent() != 0)
		return(1);
	
	if (check_softice())
		return(1);
	
	return(0);
}


